# Observation: Urology (SZZ CZ) - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Observation: Urology (SZZ CZ)**

## Resource Profile: Observation: Urology (SZZ CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-urology | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:CZ_ObservationUrology |

 
This profile defines how to represent Urology Observation resource in HL7 FHIR for the scope of this guide. 

**Usages:**

* Refer to this Profile: [Composition (SZZ CZ)](StructureDefinition-cz-composition-sharedhealthrecord.md)
* Examples for this Profile: [Observation/bc143cd8-4638-4823-87d5-6bc16ce68e85](Observation-bc143cd8-4638-4823-87d5-6bc16ce68e85.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.szz|current/StructureDefinition/cz-observation-urology)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-observation-urology.csv), [Excel](StructureDefinition-cz-observation-urology.xlsx), [Schematron](StructureDefinition-cz-observation-urology.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-observation-urology",
  "url" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-urology",
  "version" : "0.0.1",
  "name" : "CZ_ObservationUrology",
  "title" : "Observation: Urology (SZZ CZ)",
  "status" : "draft",
  "date" : "2025-12-22T12:04:24+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This profile defines how to represent Urology Observation resource in HL7 FHIR for the scope of this guide.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation"
      },
      {
        "id" : "Observation.code.coding",
        "path" : "Observation.code.coding",
        "patternCoding" : {
          "system" : "http://snomed.info/sct",
          "code" : "249604002"
        }
      },
      {
        "id" : "Observation.subject",
        "path" : "Observation.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
            ]
          }
        ]
      },
      {
        "id" : "Observation.effective[x]",
        "path" : "Observation.effective[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.effective[x]:effectiveDateTime",
        "path" : "Observation.effective[x]",
        "sliceName" : "effectiveDateTime",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "Observation.value[x]",
        "path" : "Observation.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.value[x]:valueCodeableConcept",
        "path" : "Observation.value[x]",
        "sliceName" : "valueCodeableConcept",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-urology-result-vs"
        }
      },
      {
        "id" : "Observation.interpretation",
        "path" : "Observation.interpretation",
        "short" : "Interpretation of the urology findings",
        "definition" : "This element provides an overall interpretation of the urology findings, summarizing the results and their clinical significance.",
        "max" : "1"
      },
      {
        "id" : "Observation.interpretation.coding",
        "path" : "Observation.interpretation.coding",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-urology-interpretation-vs"
        }
      },
      {
        "id" : "Observation.interpretation.text",
        "path" : "Observation.interpretation.text",
        "short" : "Interpretation text",
        "definition" : "A human-readable summary of the interpretation of the other urology findings."
      },
      {
        "id" : "Observation.component",
        "path" : "Observation.component",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Components of the urology observation",
        "min" : 1
      },
      {
        "id" : "Observation.component:PSALevel",
        "path" : "Observation.component",
        "sliceName" : "PSALevel",
        "short" : "PSA level in µg/l",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:PSALevel.code",
        "path" : "Observation.component.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "443969004",
              "display" : "Quantitative measurement of mass concentration of prostate specific antigen in serum or plasma"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:PSALevel.value[x]",
        "path" : "Observation.component.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.component:PSALevel.value[x]:valueQuantity",
        "path" : "Observation.component.value[x]",
        "sliceName" : "valueQuantity",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "Observation.component:PSALevel.value[x]:valueQuantity.code",
        "path" : "Observation.component.value[x].code",
        "patternCode" : "ug/l"
      },
      {
        "id" : "Observation.component:ProstateVolume",
        "path" : "Observation.component",
        "sliceName" : "ProstateVolume",
        "short" : "Prostate volume in ml",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:ProstateVolume.code",
        "path" : "Observation.component.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "1297142007",
              "display" : "Prostate volume"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:ProstateVolume.value[x]",
        "path" : "Observation.component.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.component:ProstateVolume.value[x]:valueQuantity",
        "path" : "Observation.component.value[x]",
        "sliceName" : "valueQuantity",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "Observation.component:ProstateVolume.value[x]:valueQuantity.code",
        "path" : "Observation.component.value[x].code",
        "patternCode" : "ml"
      },
      {
        "id" : "Observation.component:PSAdensity",
        "path" : "Observation.component",
        "sliceName" : "PSAdensity",
        "short" : "PSA density in ng/ml/cm3",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:PSAdensity.code",
        "path" : "Observation.component.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "15325-4"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:PSAdensity.value[x]",
        "path" : "Observation.component.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.component:PSAdensity.value[x]:valueQuantity",
        "path" : "Observation.component.value[x]",
        "sliceName" : "valueQuantity",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "Observation.component:PSAdensity.value[x]:valueQuantity.code",
        "path" : "Observation.component.value[x].code",
        "patternCode" : "ng/ml/cm3"
      },
      {
        "id" : "Observation.component:PSAvelocity",
        "path" : "Observation.component",
        "sliceName" : "PSAvelocity",
        "short" : "PSA velocity in ng/ml/annus",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:PSAvelocity.code",
        "path" : "Observation.component.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "63476009",
              "display" : "Prostate specific antigen measurement"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:PSAvelocity.value[x]",
        "path" : "Observation.component.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.component:PSAvelocity.value[x]:valueQuantity",
        "path" : "Observation.component.value[x]",
        "sliceName" : "valueQuantity",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "Observation.component:PSAvelocity.value[x]:valueQuantity.code",
        "path" : "Observation.component.value[x].code",
        "patternCode" : "ng/ml/a"
      }
    ]
  }
}

```
