# Observation: Colonoscopy (SZZ CZ) - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Observation: Colonoscopy (SZZ CZ)**

## Resource Profile: Observation: Colonoscopy (SZZ CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-colonoscopy | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:CZ_ObservationColonoscopy |

 
This profile defines how to represent Colonoscopy Observation resource in HL7 FHIR for the scope of this guide. 

**Usages:**

* Refer to this Profile: [Composition (SZZ CZ)](StructureDefinition-cz-composition-sharedhealthrecord.md)
* Examples for this Profile: [Observation/cd2b65ad-9926-4589-98c9-7e581e21602a](Observation-cd2b65ad-9926-4589-98c9-7e581e21602a.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.szz|current/StructureDefinition/cz-observation-colonoscopy)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-observation-colonoscopy.csv), [Excel](StructureDefinition-cz-observation-colonoscopy.xlsx), [Schematron](StructureDefinition-cz-observation-colonoscopy.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-observation-colonoscopy",
  "url" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-colonoscopy",
  "version" : "0.0.1",
  "name" : "CZ_ObservationColonoscopy",
  "title" : "Observation: Colonoscopy (SZZ CZ)",
  "status" : "draft",
  "date" : "2025-12-22T12:04:24+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This profile defines how to represent Colonoscopy Observation resource in HL7 FHIR for the scope of this guide.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation"
      },
      {
        "id" : "Observation.status",
        "path" : "Observation.status",
        "short" : "Status of the colonoscopy observation - preliminary or final",
        "definition" : "The status of the colonoscopy observation indicates whether the finding is preliminary (not yet verified) or final (verified by the practitioner)."
      },
      {
        "id" : "Observation.code.coding",
        "path" : "Observation.code.coding",
        "patternCoding" : {
          "system" : "http://snomed.info/sct",
          "code" : "73761001"
        }
      },
      {
        "id" : "Observation.subject",
        "path" : "Observation.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
            ]
          }
        ]
      },
      {
        "id" : "Observation.effective[x]",
        "path" : "Observation.effective[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.effective[x]:effectiveDateTime",
        "path" : "Observation.effective[x]",
        "sliceName" : "effectiveDateTime",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "Observation.interpretation",
        "path" : "Observation.interpretation",
        "short" : "Interpretation of the colonoscopy findings",
        "definition" : "This element provides an overall interpretation of the colonoscopy findings, summarizing the results and their clinical significance.",
        "max" : "1"
      },
      {
        "id" : "Observation.interpretation.coding",
        "path" : "Observation.interpretation.coding",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-colonoscopy-interpretation-vs"
        }
      },
      {
        "id" : "Observation.interpretation.text",
        "path" : "Observation.interpretation.text",
        "short" : "Interpretation text",
        "definition" : "A human-readable summary of the interpretation of the other colonoscopy findings."
      },
      {
        "id" : "Observation.component",
        "path" : "Observation.component",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Components of the colonoscopy observation",
        "min" : 1
      },
      {
        "id" : "Observation.component:ColonoscopyType",
        "path" : "Observation.component",
        "sliceName" : "ColonoscopyType",
        "short" : "Type of colonoscopy",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:ColonoscopyType.code",
        "path" : "Observation.component.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "276218009",
              "display" : "Procedure type"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:ColonoscopyType.value[x]",
        "path" : "Observation.component.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.component:ColonoscopyType.value[x]:valueCodeableConcept",
        "path" : "Observation.component.value[x]",
        "sliceName" : "valueCodeableConcept",
        "short" : "Type of conoloscopy",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-colonoscopy-type-vs"
        }
      },
      {
        "id" : "Observation.component:ColonoscopyBBPS",
        "path" : "Observation.component",
        "sliceName" : "ColonoscopyBBPS",
        "short" : "Boston Bowel Preparation Scale (BBPS) score",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:ColonoscopyBBPS.code",
        "path" : "Observation.component.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "722818007",
              "display" : "Boston bowel preparation scale"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:ColonoscopyBBPS.value[x]",
        "path" : "Observation.component.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.component:ColonoscopyBBPS.value[x]:valueInteger",
        "path" : "Observation.component.value[x]",
        "sliceName" : "valueInteger",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "integer"
          }
        ]
      },
      {
        "id" : "Observation.component:ColonoscopyNormal",
        "path" : "Observation.component",
        "sliceName" : "ColonoscopyNormal",
        "short" : "Indication of normal findings during colonoscopy",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:ColonoscopyNormal.code",
        "path" : "Observation.component.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "313170008",
              "display" : "Colonoscopy normal"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:ColonoscopyNormal.value[x]",
        "path" : "Observation.component.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.component:ColonoscopyNormal.value[x]:valueBoolean",
        "path" : "Observation.component.value[x]",
        "sliceName" : "valueBoolean",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "boolean"
          }
        ]
      },
      {
        "id" : "Observation.component:ColonoscopyQuantityFindings",
        "path" : "Observation.component",
        "sliceName" : "ColonoscopyQuantityFindings",
        "short" : "Number of abnormal findings during colonoscopy",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:ColonoscopyQuantityFindings.code",
        "path" : "Observation.component.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "30766002",
              "display" : "Quantitative"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:ColonoscopyQuantityFindings.value[x]",
        "path" : "Observation.component.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.component:ColonoscopyQuantityFindings.value[x]:valueInteger",
        "path" : "Observation.component.value[x]",
        "sliceName" : "valueInteger",
        "short" : "Number of abnormal findings",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "integer"
          }
        ]
      },
      {
        "id" : "Observation.component:ColonoscopyAbnormal",
        "path" : "Observation.component",
        "sliceName" : "ColonoscopyAbnormal",
        "short" : "Indication of abnormal findings during colonoscopy",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:ColonoscopyAbnormal.code",
        "path" : "Observation.component.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "313172000",
              "display" : "Colonoscopy abnormal"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:ColonoscopyAbnormal.value[x]",
        "path" : "Observation.component.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.component:ColonoscopyAbnormal.value[x]:valueCodeableConcept",
        "path" : "Observation.component.value[x]",
        "sliceName" : "valueCodeableConcept",
        "short" : "Type of abnormal findings",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-colonoscopy-abnormal-findings-vs"
        }
      }
    ]
  }
}

```
