# Observation: Abdomina aortic aneurysms (SZZ CZ) - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Observation: Abdomina aortic aneurysms (SZZ CZ)**

## Resource Profile: Observation: Abdomina aortic aneurysms (SZZ CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-abdomina-aortic-aneurysms | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:CZ_ObservationAbdominaAorticAneurysms |

 
This profile defines how to represent Abodmina Aortic Aneurysms Observation resource in HL7 FHIR for the scope of this guide. 

**Usages:**

* Refer to this Profile: [Composition (SZZ CZ)](StructureDefinition-cz-composition-sharedhealthrecord.md)
* Examples for this Profile: [Observation/dd8033d4-d1c9-48e8-8edd-c0dda913678d](Observation-dd8033d4-d1c9-48e8-8edd-c0dda913678d.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.szz|current/StructureDefinition/cz-observation-abdomina-aortic-aneurysms)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-observation-abdomina-aortic-aneurysms.csv), [Excel](StructureDefinition-cz-observation-abdomina-aortic-aneurysms.xlsx), [Schematron](StructureDefinition-cz-observation-abdomina-aortic-aneurysms.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-observation-abdomina-aortic-aneurysms",
  "url" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-abdomina-aortic-aneurysms",
  "version" : "0.0.1",
  "name" : "CZ_ObservationAbdominaAorticAneurysms",
  "title" : "Observation: Abdomina aortic aneurysms (SZZ CZ)",
  "status" : "draft",
  "date" : "2025-12-22T12:04:24+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This profile defines how to represent Abodmina Aortic Aneurysms Observation resource in HL7 FHIR for the scope of this guide.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation"
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "698356002",
              "display" : "Abdominal aortic aneurysm screening"
            }
          ]
        }
      },
      {
        "id" : "Observation.effective[x]",
        "path" : "Observation.effective[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.effective[x]:effectiveDateTime",
        "path" : "Observation.effective[x]",
        "sliceName" : "effectiveDateTime",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "Observation.value[x]",
        "path" : "Observation.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.value[x]:valueCodeableConcept",
        "path" : "Observation.value[x]",
        "sliceName" : "valueCodeableConcept",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-abdomina-aortic-aneurysms-result-vs"
        }
      }
    ]
  }
}

```
