# Observation: Weight (SZZ CZ) - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Observation: Weight (SZZ CZ)**

## Resource Profile: Observation: Weight (SZZ CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/szz/StructureDefinition/cz-bodyweight | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:CZ_BodyWeight |

 
Profile of body weight for the scope of the Czech national interoperability project. 

**Usages:**

* Use this Profile: [Bundle (SZZ CZ)](StructureDefinition-cz-bundle-sharedhealthrecord.md)
* Refer to this Profile: [Composition (SZZ CZ)](StructureDefinition-cz-composition-sharedhealthrecord.md)
* Examples for this Profile: [Observation/31e1de93-1c46-4f9e-849c-c46f8c7f1496](Observation-31e1de93-1c46-4f9e-849c-c46f8c7f1496.md) and [Observation/8a6733be-e107-44b6-99a8-77869faea42a](Observation-8a6733be-e107-44b6-99a8-77869faea42a.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.szz|current/StructureDefinition/cz-bodyweight)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-bodyweight.csv), [Excel](StructureDefinition-cz-bodyweight.xlsx), [Schematron](StructureDefinition-cz-bodyweight.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-bodyweight",
  "url" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-bodyweight",
  "version" : "0.0.1",
  "name" : "CZ_BodyWeight",
  "title" : "Observation: Weight (SZZ CZ)",
  "status" : "draft",
  "date" : "2025-12-22T12:04:24+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Profile of body weight for the scope of the Czech national interoperability project.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation"
      },
      {
        "id" : "Observation.code.coding",
        "path" : "Observation.code.coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "system"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.code.coding:LOINC",
        "path" : "Observation.code.coding",
        "sliceName" : "LOINC",
        "short" : "LOINC code for the observation",
        "min" : 0,
        "max" : "1",
        "patternCoding" : {
          "system" : "http://loinc.org",
          "code" : "29463-7"
        }
      },
      {
        "id" : "Observation.code.coding:LOINC.system",
        "path" : "Observation.code.coding.system",
        "min" : 1,
        "fixedUri" : "http://loinc.org"
      },
      {
        "id" : "Observation.code.coding:LOINC.code",
        "path" : "Observation.code.coding.code",
        "min" : 1
      },
      {
        "id" : "Observation.code.coding:SNOMEDCT",
        "path" : "Observation.code.coding",
        "sliceName" : "SNOMEDCT",
        "short" : "SNOMED CT code for the observation",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.code.coding:SNOMEDCT.system",
        "path" : "Observation.code.coding.system",
        "min" : 1,
        "fixedUri" : "http://snomed.info/sct"
      },
      {
        "id" : "Observation.code.coding:SNOMEDCT.code",
        "path" : "Observation.code.coding.code",
        "min" : 1,
        "fixedCode" : "27113001"
      },
      {
        "id" : "Observation.code.coding:NCLP",
        "path" : "Observation.code.coding",
        "sliceName" : "NCLP",
        "short" : "NCLP code for the observation",
        "min" : 0,
        "max" : "1",
        "patternCoding" : {
          "system" : "https://nclp.ncez.mzcr.cz/CodeSystem/nclppol",
          "code" : "20042"
        }
      },
      {
        "id" : "Observation.code.coding:NCLP.system",
        "path" : "Observation.code.coding.system",
        "min" : 1,
        "fixedUri" : "https://nclp.ncez.mzcr.cz/CodeSystem/nclppol"
      },
      {
        "id" : "Observation.code.coding:NCLP.code",
        "path" : "Observation.code.coding.code",
        "min" : 1
      },
      {
        "id" : "Observation.effective[x]",
        "path" : "Observation.effective[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "Observation.value[x]",
        "path" : "Observation.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.value[x]:valueQuantity",
        "path" : "Observation.value[x]",
        "sliceName" : "valueQuantity",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "Observation.value[x]:valueQuantity.code",
        "path" : "Observation.value[x].code",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-observationUnitsWeight-vs"
        }
      }
    ]
  }
}

```
