# Adverse event (SZZ CZ) - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Adverse event (SZZ CZ)**

## Resource Profile: Adverse event (SZZ CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/szz/StructureDefinition/cz-adverse-event | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:CZ_AdverseEvent |

 
Czech profile for adverse event. 

**Usages:**

* Use this Profile: [Bundle (SZZ CZ)](StructureDefinition-cz-bundle-sharedhealthrecord.md)
* Refer to this Profile: [Composition (SZZ CZ)](StructureDefinition-cz-composition-sharedhealthrecord.md)
* Examples for this Profile: [AdverseEvent/74d87d39-d681-4df4-80a5-975b359e6210](AdverseEvent-74d87d39-d681-4df4-80a5-975b359e6210.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.szz|current/StructureDefinition/cz-adverse-event)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-adverse-event.csv), [Excel](StructureDefinition-cz-adverse-event.xlsx), [Schematron](StructureDefinition-cz-adverse-event.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-adverse-event",
  "url" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-adverse-event",
  "version" : "0.0.1",
  "name" : "CZ_AdverseEvent",
  "title" : "Adverse event (SZZ CZ)",
  "status" : "draft",
  "date" : "2025-12-22T12:04:24+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Czech profile for adverse event. ",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "AdverseEvent",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/AdverseEvent",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "AdverseEvent",
        "path" : "AdverseEvent"
      },
      {
        "id" : "AdverseEvent.event",
        "path" : "AdverseEvent.event",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-type-of-adverse-event-szz-vs"
        }
      },
      {
        "id" : "AdverseEvent.subject",
        "path" : "AdverseEvent.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
              "http://hl7.org/fhir/StructureDefinition/Group",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core"
            ]
          }
        ]
      },
      {
        "id" : "AdverseEvent.location",
        "path" : "AdverseEvent.location",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-location-core"
            ]
          }
        ]
      },
      {
        "id" : "AdverseEvent.recorder",
        "path" : "AdverseEvent.recorder",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core"
            ]
          }
        ]
      },
      {
        "id" : "AdverseEvent.suspectEntity",
        "path" : "AdverseEvent.suspectEntity",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "instance"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "AdverseEvent.suspectEntity:medication",
        "path" : "AdverseEvent.suspectEntity",
        "sliceName" : "medication",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "AdverseEvent.suspectEntity:medication.instance",
        "path" : "AdverseEvent.suspectEntity.instance",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-Medication",
              "http://hl7.org/fhir/StructureDefinition/Substance"
            ]
          }
        ]
      }
    ]
  }
}

```
