# A.3.4 - Radiology - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.3.4 - Radiology**

## Logical Model: A.3.4 - Radiology 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/szz/StructureDefinition/RadiologyCz | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:LogEnRadiologyCz |

 
Shared Health Record - Screening examination by radiologist. 

**Usages:**

* Use this Logical Model: [A.3 - Preventive and screening health record](StructureDefinition-PreventiveAndScreeningRecordCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.szz|current/StructureDefinition/RadiologyCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-RadiologyCz.csv), [Excel](StructureDefinition-RadiologyCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "RadiologyCz",
  "url" : "https://hl7.cz/fhir/szz/StructureDefinition/RadiologyCz",
  "version" : "0.0.1",
  "name" : "LogEnRadiologyCz",
  "title" : "A.3.4 - Radiology",
  "status" : "draft",
  "date" : "2025-12-22T12:04:24+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Shared Health Record - Screening examination by radiologist.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/szz/StructureDefinition/RadiologyCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "RadiologyCz",
        "path" : "RadiologyCz",
        "short" : "A.3.4 - Radiology",
        "definition" : "Shared Health Record - Screening examination by radiologist."
      },
      {
        "id" : "RadiologyCz.mammographyExamination",
        "path" : "RadiologyCz.mammographyExamination",
        "short" : "A.3.4.1 - Result of mammography examination as part of breast cancer screening",
        "definition" : "A.3.4.1 - Result of mammography examination as part of breast cancer screening",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "RadiologyCz.mammographyExamination.resultDate",
        "path" : "RadiologyCz.mammographyExamination.resultDate",
        "short" : "A.3.4.1.1 - Date of mammography examination result",
        "definition" : "Date of mammography.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "RadiologyCz.mammographyExamination.tissueDensity",
        "path" : "RadiologyCz.mammographyExamination.tissueDensity",
        "short" : "A.3.4.1.2 - Breast tissue density according to BIRADS/Tabár classification",
        "definition" : "Breast tissue density of the patient.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "RadiologyCz.mammographyExamination.examinationResult",
        "path" : "RadiologyCz.mammographyExamination.examinationResult",
        "short" : "A.3.4.1.3 - Mammography result",
        "definition" : "Mammography result.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "RadiologyCz.breastBiopsyResult",
        "path" : "RadiologyCz.breastBiopsyResult",
        "short" : "A.3.4.2 - Breast cancer screening biopsy result",
        "definition" : "A.3.4.2 - Breast cancer screening biopsy result",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "RadiologyCz.breastBiopsyResult.resultDate",
        "path" : "RadiologyCz.breastBiopsyResult.resultDate",
        "short" : "A.3.4.2.1 - Biopsy result date",
        "definition" : "Date of biopsy.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "RadiologyCz.breastBiopsyResult.biopsyType",
        "path" : "RadiologyCz.breastBiopsyResult.biopsyType",
        "short" : "A.3.4.2.2 - Biopsy type",
        "definition" : "Type of biopsy performed.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "RadiologyCz.breastBiopsyResult.biopsyResult",
        "path" : "RadiologyCz.breastBiopsyResult.biopsyResult",
        "short" : "A.3.4.2.3 - Biopsy result",
        "definition" : "Result of the biopsy performed.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "RadiologyCz.lungExamination",
        "path" : "RadiologyCz.lungExamination",
        "short" : "A.3.4.3 - Result of examination for early detection of lung cancer",
        "definition" : "A.3.4.3 - Result of examination for early detection of lung cancer",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "RadiologyCz.lungExamination.resultDate",
        "path" : "RadiologyCz.lungExamination.resultDate",
        "short" : "A.3.4.3.1 - Date of LDCT result",
        "definition" : "Date of LDCT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "RadiologyCz.lungExamination.examinationType",
        "path" : "RadiologyCz.lungExamination.examinationType",
        "short" : "A.3.4.3.2 - Type of LDCT examination",
        "definition" : "The patient undergoes an initial examination, a follow-up examination at the scheduled time, or a follow-up examination after an inconclusive result.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "RadiologyCz.lungExamination.examinationResult",
        "path" : "RadiologyCz.lungExamination.examinationResult",
        "short" : "A.3.4.3.3 - LDCT result",
        "definition" : "LDCT screening result.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "RadiologyCz.lungExamination.recommendedProcedure",
        "path" : "RadiologyCz.lungExamination.recommendedProcedure",
        "short" : "A.3.4.3.4 - LDCT examination result: Further recommended examinations",
        "definition" : "Final evaluation of results by a physician.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "RadiologyCz.prostateExamination",
        "path" : "RadiologyCz.prostateExamination",
        "short" : "A.3.4.4 - Prostate cancer early detection examination result",
        "definition" : "A.3.4.4 - Prostate cancer early detection examination result",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "RadiologyCz.prostateExamination.resultDate",
        "path" : "RadiologyCz.prostateExamination.resultDate",
        "short" : "A.3.4.4.1 - MRI result date",
        "definition" : "Date of MRI",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "RadiologyCz.prostateExamination.examinationType",
        "path" : "RadiologyCz.prostateExamination.examinationType",
        "short" : "A.3.4.4.2 - Type of MRI examination",
        "definition" : "The patient undergoes an MRI without contrast agent or an MRI with contrast agent.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "RadiologyCz.prostateExamination.examinationResult",
        "path" : "RadiologyCz.prostateExamination.examinationResult",
        "short" : "A.3.4.4.3 - MRI result (PI-RADS)",
        "definition" : "MRI result according to the PI-RADS system (assessment score).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "RadiologyCz.prostateExamination.findingPIRADS3",
        "path" : "RadiologyCz.prostateExamination.findingPIRADS3",
        "short" : "A.3.4.4.4 - Finding in the case of PI-RADS 3",
        "definition" : "Zone of finding in the case of PI-RADS 3.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "RadiologyCz.examinationAneurysmAbnormalAorta",
        "path" : "RadiologyCz.examinationAneurysmAbnormalAorta",
        "short" : "A.3.4.5 - Result of examination as part of abdominal aortic aneurysm screening",
        "definition" : "A.3.4.5 - Result of examination as part of abdominal aortic aneurysm screening",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "RadiologyCz.examinationAneurysmAbnormalAorta.resultDate",
        "path" : "RadiologyCz.examinationAneurysmAbnormalAorta.resultDate",
        "short" : "A.3.4.5.1 - Date of USG examination result",
        "definition" : "Date on which the patient underwent screening ultrasonography.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "RadiologyCz.examinationAneurysmAbnormalAorta.examinationResult",
        "path" : "RadiologyCz.examinationAneurysmAbnormalAorta.examinationResult",
        "short" : "A.3.4.5.2 - Ultrasound examination result",
        "definition" : "Result of the screening ultrasound examination.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      }
    ]
  }
}

```
