# A.3 - Preventive and screening health record - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.3 - Preventive and screening health record**

## Logical Model: A.3 - Preventive and screening health record 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/szz/StructureDefinition/PreventiveAndScreeningRecordCz | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:LogEnPreventiveAndScreeningRecordCz |

 
Shared Health Record - Logical model of Preventive and screening health record 

**Usages:**

* Use this Logical Model: [A - Shared Health Record](StructureDefinition-SzzCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.szz|current/StructureDefinition/PreventiveAndScreeningRecordCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-PreventiveAndScreeningRecordCz.csv), [Excel](StructureDefinition-PreventiveAndScreeningRecordCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "PreventiveAndScreeningRecordCz",
  "url" : "https://hl7.cz/fhir/szz/StructureDefinition/PreventiveAndScreeningRecordCz",
  "version" : "0.0.1",
  "name" : "LogEnPreventiveAndScreeningRecordCz",
  "title" : "A.3 - Preventive and screening health record",
  "status" : "draft",
  "date" : "2025-12-22T12:04:24+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Shared Health Record - Logical model of Preventive and screening health record",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/szz/StructureDefinition/PreventiveAndScreeningRecordCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "PreventiveAndScreeningRecordCz",
        "path" : "PreventiveAndScreeningRecordCz",
        "short" : "A.3 - Preventive and screening health record",
        "definition" : "Shared Health Record - Logical model of Preventive and screening health record"
      },
      {
        "id" : "PreventiveAndScreeningRecordCz.generalPractitioner",
        "path" : "PreventiveAndScreeningRecordCz.generalPractitioner",
        "short" : "A.3.1 - General Practitioner",
        "definition" : "A.3.1 - General Practitioner",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/szz/StructureDefinition/GeneralPractitionerCz"
          }
        ]
      },
      {
        "id" : "PreventiveAndScreeningRecordCz.gynekology",
        "path" : "PreventiveAndScreeningRecordCz.gynekology",
        "short" : "A.3.2 - Gynekology",
        "definition" : "A.3.2 - Gynekology",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/szz/StructureDefinition/GynecologyCz"
          }
        ]
      },
      {
        "id" : "PreventiveAndScreeningRecordCz.gastroenterology",
        "path" : "PreventiveAndScreeningRecordCz.gastroenterology",
        "short" : "A.3.3 - Gatroenterology",
        "definition" : "A.3.3 - Gatroenterology",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/szz/StructureDefinition/GastroenterologyCz"
          }
        ]
      },
      {
        "id" : "PreventiveAndScreeningRecordCz.radiology",
        "path" : "PreventiveAndScreeningRecordCz.radiology",
        "short" : "A.3.4 - Radiology",
        "definition" : "A.3.4 - Radiology",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/szz/StructureDefinition/RadiologyCz"
          }
        ]
      },
      {
        "id" : "PreventiveAndScreeningRecordCz.biochemistryLab",
        "path" : "PreventiveAndScreeningRecordCz.biochemistryLab",
        "short" : "A.3.5 - Biochemistry Lab",
        "definition" : "A.3.5 - Biochemistry Lab",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/szz/StructureDefinition/BiochemistryLabCz"
          }
        ]
      },
      {
        "id" : "PreventiveAndScreeningRecordCz.pulmonology",
        "path" : "PreventiveAndScreeningRecordCz.pulmonology",
        "short" : "A.3.6 - Pulmonology",
        "definition" : "A.3.6 - Pulmonology",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/szz/StructureDefinition/PulmonologyCz"
          }
        ]
      },
      {
        "id" : "PreventiveAndScreeningRecordCz.urology",
        "path" : "PreventiveAndScreeningRecordCz.urology",
        "short" : "A.3.7 - Urology",
        "definition" : "A.3.7 - Urology",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/szz/StructureDefinition/UrologyCz"
          }
        ]
      },
      {
        "id" : "PreventiveAndScreeningRecordCz.angiology",
        "path" : "PreventiveAndScreeningRecordCz.angiology",
        "short" : "A.3.8 - Angiology",
        "definition" : "A.3.8 - Angiology",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/szz/StructureDefinition/AngiologyCz"
          }
        ]
      }
    ]
  }
}

```
