# A.3.7 - Urolog - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.3.7 - Urolog**

## Logical Model: A.3.7 - Urolog 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/szz/StructureDefinition/LogUrologyCz | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:LogCzUrologyCz |

 
Sdílený zdravotní záznam - Screeningové vyšetření urologem. 

**Usages:**

* Use this Logical Model: [A.3 - Preventivní a screeningový zdravotní záznam](StructureDefinition-LogPreventiveAndScreeningRecordCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.szz|current/StructureDefinition/LogUrologyCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogUrologyCz.csv), [Excel](StructureDefinition-LogUrologyCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogUrologyCz",
  "url" : "https://hl7.cz/fhir/szz/StructureDefinition/LogUrologyCz",
  "version" : "0.0.1",
  "name" : "LogCzUrologyCz",
  "title" : "A.3.7 - Urolog",
  "status" : "draft",
  "date" : "2025-12-22T12:04:24+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Sdílený zdravotní záznam - Screeningové vyšetření urologem.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/szz/StructureDefinition/LogUrologyCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogUrologyCz",
        "path" : "LogUrologyCz",
        "short" : "A.3.7 - Urolog",
        "definition" : "Sdílený zdravotní záznam - Screeningové vyšetření urologem."
      },
      {
        "id" : "LogUrologyCz.vysetreniKarcinomuProstaty",
        "path" : "LogUrologyCz.vysetreniKarcinomuProstaty",
        "short" : "A.3.7.1 - Výsledek vstupního PSA vyšetření v rámci časného záchytu karcinomu prostaty",
        "definition" : "A.3.7.1 - Výsledek vstupního PSA vyšetření v rámci časného záchytu karcinomu prostaty",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogUrologyCz.vysetreniKarcinomuProstaty.datumVysledku",
        "path" : "LogUrologyCz.vysetreniKarcinomuProstaty.datumVysledku",
        "short" : "A.3.7.1.1 - Datum výsledku screeningového PSA",
        "definition" : "Datum, kdy je pacientovi proveden odběr screeningového PSA (vstupní PSA odběr v rámci screeningové epizody).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogUrologyCz.vysetreniKarcinomuProstaty.hladinaPSA",
        "path" : "LogUrologyCz.vysetreniKarcinomuProstaty.hladinaPSA",
        "short" : "A.3.7.1.2 - Hladina screeningového PSA",
        "definition" : "Hodnota screeningového PSA v  UG/L (hodnota vstupního PSA odběru v rámci screeningové epizody).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "LogUrologyCz.navazujiciUrologickeVysetreni",
        "path" : "LogUrologyCz.navazujiciUrologickeVysetreni",
        "short" : "A.3.7.2 - Výsledek navazujících urologického vyšetření  v rámci časného záchytu karcinomu prostaty",
        "definition" : "A.3.7.2 - Výsledek navazujících urologického vyšetření  v rámci časného záchytu karcinomu prostaty",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogUrologyCz.navazujiciUrologickeVysetreni.datumVysledku",
        "path" : "LogUrologyCz.navazujiciUrologickeVysetreni.datumVysledku",
        "short" : "A.3.7.2.1 - Datum výsledku vyšetření",
        "definition" : "Datum, kdy bylo provedeno vyšetření.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogUrologyCz.navazujiciUrologickeVysetreni.vysledekVysetreni",
        "path" : "LogUrologyCz.navazujiciUrologickeVysetreni.vysledekVysetreni",
        "short" : "A.3.7.2.2 - Výsledek klinického vyšetření",
        "definition" : "Výsledek provedeného klinického vyšetření (per rectum a případná další vyšetření).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogUrologyCz.navazujiciUrologickeVysetreni.hladinaPSA",
        "path" : "LogUrologyCz.navazujiciUrologickeVysetreni.hladinaPSA",
        "short" : "A.3.7.2.3 - Hladina PSA",
        "definition" : "Hodnota navazujícího PSA v  UG/L (hodnota PSA odběru).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "LogUrologyCz.navazujiciUrologickeVysetreni.objemProstaty",
        "path" : "LogUrologyCz.navazujiciUrologickeVysetreni.objemProstaty",
        "short" : "A.3.7.2.4 - Objem prostaty",
        "definition" : "Objem prostaty ze zobrazovacích vyšetření.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "LogUrologyCz.navazujiciUrologickeVysetreni.denzitaPSA",
        "path" : "LogUrologyCz.navazujiciUrologickeVysetreni.denzitaPSA",
        "short" : "A.3.7.2.5 - Určení PSA denzity (PSAD)",
        "definition" : "PSA denzita.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "LogUrologyCz.navazujiciUrologickeVysetreni.velocitaPSA",
        "path" : "LogUrologyCz.navazujiciUrologickeVysetreni.velocitaPSA",
        "short" : "A.3.7.2.6 - Určení PSA velocity (PSAV)",
        "definition" : "PSA velocita (ng/ml/rok). PSAV se neprovádí v případě, když je k dispozici pouze jeden výsledek PSA.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "LogUrologyCz.navazujiciUrologickeVysetreni.dalsiPostup",
        "path" : "LogUrologyCz.navazujiciUrologickeVysetreni.dalsiPostup",
        "short" : "A.3.7.2.7 - Výsledek vyšetření: Další doporučené vyšetření",
        "definition" : "Závěrečné zhodnocení výsledků lékařem.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogUrologyCz.navazujiciBioptickeVysetreni",
        "path" : "LogUrologyCz.navazujiciBioptickeVysetreni",
        "short" : "A.3.7.3 - Výsledek navazujícího bioptického vyšetření v rámci časného záchytu karcinomu prostaty",
        "definition" : "A.3.7.3 - Výsledek navazujícího bioptického vyšetření v rámci časného záchytu karcinomu prostaty",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogUrologyCz.navazujiciBioptickeVysetreni.datumVysledku",
        "path" : "LogUrologyCz.navazujiciBioptickeVysetreni.datumVysledku",
        "short" : "A.3.7.3.1 - Datum výsledku bioptického vyšetření",
        "definition" : "Datum provedeného bioptického vyšetření prostaty na akreditovaném pracovišti.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogUrologyCz.navazujiciBioptickeVysetreni.typBiopsie",
        "path" : "LogUrologyCz.navazujiciBioptickeVysetreni.typBiopsie",
        "short" : "A.3.7.3.2 - Typ provedené biopsie",
        "definition" : "Typ provedené biopsie prostaty.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogUrologyCz.navazujiciBioptickeVysetreni.vysledekVysetreni",
        "path" : "LogUrologyCz.navazujiciBioptickeVysetreni.vysledekVysetreni",
        "short" : "A.3.7.3.3 - Výsledek bioptického vyšetření",
        "definition" : "Výsledek bioptického vyšetření.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      }
    ]
  }
}

```
