# A.3.6 - Pulmonology - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.3.6 - Pulmonology**

## Logical Model: A.3.6 - Pulmonology 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/szz/StructureDefinition/LogPulmonologyCz | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:LogCzPulmonologyCz |

 
Sdílený zdravotní záznam - Screeningové vyšetření pneumologem. 

**Usages:**

* Use this Logical Model: [A.3 - Preventivní a screeningový zdravotní záznam](StructureDefinition-LogPreventiveAndScreeningRecordCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.szz|current/StructureDefinition/LogPulmonologyCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogPulmonologyCz.csv), [Excel](StructureDefinition-LogPulmonologyCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogPulmonologyCz",
  "url" : "https://hl7.cz/fhir/szz/StructureDefinition/LogPulmonologyCz",
  "version" : "0.0.1",
  "name" : "LogCzPulmonologyCz",
  "title" : "A.3.6 - Pulmonology",
  "status" : "draft",
  "date" : "2025-12-22T12:04:24+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Sdílený zdravotní záznam - Screeningové vyšetření pneumologem.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/szz/StructureDefinition/LogPulmonologyCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogPulmonologyCz",
        "path" : "LogPulmonologyCz",
        "short" : "A.3.6 - Pulmonology",
        "definition" : "Sdílený zdravotní záznam - Screeningové vyšetření pneumologem."
      },
      {
        "id" : "LogPulmonologyCz.vysetreniPlic",
        "path" : "LogPulmonologyCz.vysetreniPlic",
        "short" : "A.3.6.1 - Výsledek vyšetření v rámci časného záchytu karcinomu plic",
        "definition" : "A.3.6.1 - Výsledek vyšetření v rámci časného záchytu karcinomu plic",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogPulmonologyCz.vysetreniPlic.datumVysledku",
        "path" : "LogPulmonologyCz.vysetreniPlic.datumVysledku",
        "short" : "A.3.6.1.1 - Datum výsledku pneumologického vyšetření",
        "definition" : "Datum provedení pneumologického vyšetření v rámci programu časného záchytu karcinomu plic",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogPulmonologyCz.vysetreniPlic.kurak",
        "path" : "LogPulmonologyCz.vysetreniPlic.kurak",
        "short" : "A.3.6.1.2 - Kouření (anamnéza)",
        "definition" : "Stav aktuální kuřacké anamnézy.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogPulmonologyCz.vysetreniPlic.pocetLetOdKonceKoureni",
        "path" : "LogPulmonologyCz.vysetreniPlic.pocetLetOdKonceKoureni",
        "short" : "A.3.6.1.3 - Počet let od zanechání kouření",
        "definition" : "Před kolika lety pacient zanechal kouření.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "integer"
          }
        ]
      },
      {
        "id" : "LogPulmonologyCz.vysetreniPlic.pocetLetKoureni",
        "path" : "LogPulmonologyCz.vysetreniPlic.pocetLetKoureni",
        "short" : "A.3.6.1.4 - Počet let kouření",
        "definition" : "Kolik let pacient kouří/kouřil.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "integer"
          }
        ]
      },
      {
        "id" : "LogPulmonologyCz.vysetreniPlic.pocetBalickoroku",
        "path" : "LogPulmonologyCz.vysetreniPlic.pocetBalickoroku",
        "short" : "A.3.6.1.5 - Počet balíčkoroků",
        "definition" : "Počet balíčkoroků = (počet vykouřených cigaret za den / 20) × počet let kouření. Jeden balíčkorok znamená, že člověk kouřil jeden rok jednu krabičku cigaret denně (nebo 2 krabičky půl roku, nebo půl krabičky 2 roky apod.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "integer"
          }
        ]
      },
      {
        "id" : "LogPulmonologyCz.vysetreniPlic.fyzikalniVysetreni",
        "path" : "LogPulmonologyCz.vysetreniPlic.fyzikalniVysetreni",
        "short" : "A.3.6.1.6 - Výsledek fyzikálního vyšetření",
        "definition" : "Výsledek fyzikálního vyšetření.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogPulmonologyCz.vysetreniPlic.vysledekRTG",
        "path" : "LogPulmonologyCz.vysetreniPlic.vysledekRTG",
        "short" : "A.3.6.1.7 - Výsledek RTG plic",
        "definition" : "Výsledek rentgenu plic (hrudníku).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogPulmonologyCz.vysetreniPlic.funkcniVysetreni",
        "path" : "LogPulmonologyCz.vysetreniPlic.funkcniVysetreni",
        "short" : "A.3.6.1.8 - Výsledek funkčního vyšetření",
        "definition" : "Výsledek funkčního vyšetření.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogPulmonologyCz.vysetreniPlic.doporuceniLDCTplic",
        "path" : "LogPulmonologyCz.vysetreniPlic.doporuceniLDCTplic",
        "short" : "A.3.6.1.9 - Výsledek vyšetření: Doporučení screeningového LDCT plic",
        "definition" : "Závěrečné zhodnocení výsledků lékařem",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "boolean"
          }
        ]
      }
    ]
  }
}

```
