# A.3.5 - Biochemická laboratoř - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.3.5 - Biochemická laboratoř**

## Logical Model: A.3.5 - Biochemická laboratoř 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/szz/StructureDefinition/LogBiochemistryLabCz | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:LogCzBiochemistryLabCz |

 
Sdílený zdravotní záznam - Screeningy provedené Biochemickou laboratoří. 

**Usages:**

* Use this Logical Model: [A.3 - Preventivní a screeningový zdravotní záznam](StructureDefinition-LogPreventiveAndScreeningRecordCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.szz|current/StructureDefinition/LogBiochemistryLabCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogBiochemistryLabCz.csv), [Excel](StructureDefinition-LogBiochemistryLabCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogBiochemistryLabCz",
  "url" : "https://hl7.cz/fhir/szz/StructureDefinition/LogBiochemistryLabCz",
  "version" : "0.0.1",
  "name" : "LogCzBiochemistryLabCz",
  "title" : "A.3.5 - Biochemická laboratoř",
  "status" : "draft",
  "date" : "2025-12-22T12:04:24+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Sdílený zdravotní záznam - Screeningy provedené Biochemickou laboratoří.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/szz/StructureDefinition/LogBiochemistryLabCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogBiochemistryLabCz",
        "path" : "LogBiochemistryLabCz",
        "short" : "A.3.5 - Biochemická laboratoř",
        "definition" : "Sdílený zdravotní záznam - Screeningy provedené Biochemickou laboratoří."
      },
      {
        "id" : "LogBiochemistryLabCz.kolorektalniScreening",
        "path" : "LogBiochemistryLabCz.kolorektalniScreening",
        "short" : "A.3.5.1 - Výsledek vyšetření v rámci screeningu kolorektálního karcinomu",
        "definition" : "Výsledek vyšetření kvantitativního testu okultního krvácení do stolice.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogBiochemistryLabCz.kolorektalniScreening.datumVysledku",
        "path" : "LogBiochemistryLabCz.kolorektalniScreening.datumVysledku",
        "short" : "A.3.5.1.1 - Datum výsledku kvantitativního TOKS",
        "definition" : "Datum, kdy provádíte vyhodnocení vzorku (datum vykázání provedeného TOKS zdravotní pojišťovně).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogBiochemistryLabCz.kolorektalniScreening.hladinaTOKS",
        "path" : "LogBiochemistryLabCz.kolorektalniScreening.hladinaTOKS",
        "short" : "A.3.5.1.2 - Hladina TOKS",
        "definition" : "Hodnota kvantitativního imunochemického testu (µg/g).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "LogBiochemistryLabCz.vysetreniKarcinomuProstaty",
        "path" : "LogBiochemistryLabCz.vysetreniKarcinomuProstaty",
        "short" : "A.3.5.2 - Výsledek vyšetření v rámci časného záchytu karcinomu prostaty",
        "definition" : "A.3.5.2 - Výsledek vyšetření v rámci časného záchytu karcinomu prostaty",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogBiochemistryLabCz.vysetreniKarcinomuProstaty.datumAnalyzy",
        "path" : "LogBiochemistryLabCz.vysetreniKarcinomuProstaty.datumAnalyzy",
        "short" : "A.3.5.2.1 - Datum analýzy PSA",
        "definition" : "Datum analýzy krevního vzorku pro vyšetření.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogBiochemistryLabCz.vysetreniKarcinomuProstaty.hladinaPSA",
        "path" : "LogBiochemistryLabCz.vysetreniKarcinomuProstaty.hladinaPSA",
        "short" : "A.3.5.2.2 - Hladina PSA",
        "definition" : "Hladina PSA v μg/l (konkrétní číslo).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      }
    ]
  }
}

```
