# A.3.8 - Angiology - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.3.8 - Angiology**

## Logical Model: A.3.8 - Angiology 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/szz/StructureDefinition/LogAngiologyCz | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:LogCzAngiologyCz |

 
Sdílený zdravotní záznam - Screeningové vyšetření angiologem. 

**Usages:**

* Use this Logical Model: [A.3 - Preventivní a screeningový zdravotní záznam](StructureDefinition-LogPreventiveAndScreeningRecordCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.szz|current/StructureDefinition/LogAngiologyCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogAngiologyCz.csv), [Excel](StructureDefinition-LogAngiologyCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogAngiologyCz",
  "url" : "https://hl7.cz/fhir/szz/StructureDefinition/LogAngiologyCz",
  "version" : "0.0.1",
  "name" : "LogCzAngiologyCz",
  "title" : "A.3.8 - Angiology",
  "status" : "draft",
  "date" : "2025-12-22T12:04:24+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Sdílený zdravotní záznam - Screeningové vyšetření angiologem.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/szz/StructureDefinition/LogAngiologyCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogAngiologyCz",
        "path" : "LogAngiologyCz",
        "short" : "A.3.8 - Angiology",
        "definition" : "Sdílený zdravotní záznam - Screeningové vyšetření angiologem."
      },
      {
        "id" : "LogAngiologyCz.vysetreniAneurismatuAbdominalniAorty",
        "path" : "LogAngiologyCz.vysetreniAneurismatuAbdominalniAorty",
        "short" : "A.3.8.1 - Výsledek vyšetření v rámci screeningu aneurysmatu abdominální aorty",
        "definition" : "A.3.8.1 - Výsledek vyšetření v rámci screeningu aneurysmatu abdominální aorty",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogAngiologyCz.vysetreniAneurismatuAbdominalniAorty.datumVysledku",
        "path" : "LogAngiologyCz.vysetreniAneurismatuAbdominalniAorty.datumVysledku",
        "short" : "A.3.8.1.1 - Datum výsledku USG vyšetření",
        "definition" : "Datum, kdy je pacientovi provedeno screeningové ultrasonografické vyšetření.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogAngiologyCz.vysetreniAneurismatuAbdominalniAorty.vysledekVysetreni",
        "path" : "LogAngiologyCz.vysetreniAneurismatuAbdominalniAorty.vysledekVysetreni",
        "short" : "A.3.8.1.2 - Výsledek USG vyšetření",
        "definition" : "Výsledek screeningového ultrasonografického vyšetření.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      }
    ]
  }
}

```
