# A.3.2 - Gynecology - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.3.2 - Gynecology**

## Logical Model: A.3.2 - Gynecology 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/szz/StructureDefinition/GynecologyCz | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:LogEnGynecologyCz |

 
Shared Health Record - Preventive and screening examinations by a gynecologist. 

**Usages:**

* Use this Logical Model: [A.3 - Preventive and screening health record](StructureDefinition-PreventiveAndScreeningRecordCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.szz|current/StructureDefinition/GynecologyCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-GynecologyCz.csv), [Excel](StructureDefinition-GynecologyCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "GynecologyCz",
  "url" : "https://hl7.cz/fhir/szz/StructureDefinition/GynecologyCz",
  "version" : "0.0.1",
  "name" : "LogEnGynecologyCz",
  "title" : "A.3.2 - Gynecology",
  "status" : "draft",
  "date" : "2025-12-22T12:04:24+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Shared Health Record - Preventive and screening examinations by a gynecologist.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/szz/StructureDefinition/GynecologyCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "GynecologyCz",
        "path" : "GynecologyCz",
        "short" : "A.3.2 - Gynecology",
        "definition" : "Shared Health Record - Preventive and screening examinations by a gynecologist."
      },
      {
        "id" : "GynecologyCz.colorectalScreening",
        "path" : "GynecologyCz.colorectalScreening",
        "short" : "A.3.2.1 - Colorectal cancer screening test result",
        "definition" : "Result of quantitative fecal occult blood test.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "GynecologyCz.colorectalScreening.resultDate",
        "path" : "GynecologyCz.colorectalScreening.resultDate",
        "short" : "A.3.2.1.1 - Date of quantitative FOBT result",
        "definition" : "Date on which you evaluate the sample (date on which the FOBT is reported to the health insurance company). Applies to tests evaluated in a doctor's office or laboratory.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "GynecologyCz.colorectalScreening.resultTOKS",
        "path" : "GynecologyCz.colorectalScreening.resultTOKS",
        "short" : "A.3.2.1.2 - Quantitative TOKS result (health service code reported to the health insurance company)",
        "definition" : "Health service code reported to the insurance company based on the result of the quantitative TOKS screening.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "GynecologyCz.colorectalScreening.levelTOKS",
        "path" : "GynecologyCz.colorectalScreening.levelTOKS",
        "short" : "A.3.2.1.3 - TOKS level",
        "definition" : "Quantitative immunochemical test value (µg/g).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "GynecologyCz.examinationCytology",
        "path" : "GynecologyCz.examinationCytology",
        "short" : "A.3.2.2 - Result of cytological examination as part of cervical cancer screening",
        "definition" : "A.3.2.2 - Result of cytological examination as part of cervical cancer screening",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "GynecologyCz.examinationCytology.examinationDate",
        "path" : "GynecologyCz.examinationCytology.examinationDate",
        "short" : "A.3.2.2.1 - Date of cytological examination",
        "definition" : "Date of collection of material for cytological examination (cervical smear).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "GynecologyCz.examinationCytology.examinationResult",
        "path" : "GynecologyCz.examinationCytology.examinationResult",
        "short" : "A.3.2.2.2 - Result of cytological examination",
        "definition" : "Result of cytological examination.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "GynecologyCz.examinationHPV",
        "path" : "GynecologyCz.examinationHPV",
        "short" : "A.3.2.3 - Result of HPV test as part of cervical cancer screening",
        "definition" : "A.3.2.3 - Result of HPV test as part of cervical cancer screening",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "GynecologyCz.examinationHPV.examinationDate",
        "path" : "GynecologyCz.examinationHPV.examinationDate",
        "short" : "A.3.2.3.1 - Date of high-risk HPV test",
        "definition" : "Date on which material is collected from the patient's cervix.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "GynecologyCz.examinationHPV.resultHPV",
        "path" : "GynecologyCz.examinationHPV.resultHPV",
        "short" : "A.3.2.3.2 - Result of high-risk HPV test",
        "definition" : "Result of HPV test.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "GynecologyCz.expertColposcopy",
        "path" : "GynecologyCz.expertColposcopy",
        "short" : "A.3.2.4 - Result of expert colposcopy as part of cervical cancer screening",
        "definition" : "A.3.2.4 - Result of expert colposcopy as part of cervical cancer screening",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "GynecologyCz.expertColposcopy.examinationDate",
        "path" : "GynecologyCz.expertColposcopy.examinationDate",
        "short" : "A.3.2.4.1 - Date of expert colposcopy",
        "definition" : "Date on which the patient underwent expert colposcopy.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "GynecologyCz.expertColposcopy.examinationResult",
        "path" : "GynecologyCz.expertColposcopy.examinationResult",
        "short" : "A.3.2.4.2 - Result of expert colposcopy",
        "definition" : "Evaluation of the result of expert colposcopy. The finding is normal and no further intervention is required, or the examination needs to be repeated after a certain interval, or a biopsy is required.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "GynecologyCz.preventiveCheckUp",
        "path" : "GynecologyCz.preventiveCheckUp",
        "short" : "A.3.2.5 - Result of examination as part of preventive check-up",
        "definition" : "A.3.2.5 - Result of examination as part of preventive check-up",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "GynecologyCz.preventiveCheckUp.examinationDate",
        "path" : "GynecologyCz.preventiveCheckUp.examinationDate",
        "short" : "A.3.2.5.1 - Date of result of preventive check-up",
        "definition" : "Date of preventive check-up.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "GynecologyCz.preventiveCheckUp.height",
        "path" : "GynecologyCz.preventiveCheckUp.height",
        "short" : "A.3.2.5.2 - Height",
        "definition" : "The patient's height in cm.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "GynecologyCz.preventiveCheckUp.weight",
        "path" : "GynecologyCz.preventiveCheckUp.weight",
        "short" : "A.3.2.5.3 - Weight",
        "definition" : "The patient's weight in kg.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "GynecologyCz.preventiveCheckUp.vaccinationHPV",
        "path" : "GynecologyCz.preventiveCheckUp.vaccinationHPV",
        "short" : "A.3.2.5.4 - HPV vaccination",
        "definition" : "The patient has/has not completed HPV vaccination.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "boolean"
          }
        ]
      },
      {
        "id" : "GynecologyCz.preventiveCheckUp.lastHPVVaccinationDate",
        "path" : "GynecologyCz.preventiveCheckUp.lastHPVVaccinationDate",
        "short" : "A.3.2.5.5 - HPV vaccination - year of last dose",
        "definition" : "Year when the patient received the last dose of HPV vaccination.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ]
      },
      {
        "id" : "GynecologyCz.preventiveCheckUp.vaccineHPV",
        "path" : "GynecologyCz.preventiveCheckUp.vaccineHPV",
        "short" : "A.3.2.5.6 - HPV vaccination - vaccine",
        "definition" : "The vaccine that was administered to the patient.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      }
    ]
  }
}

```
