# A.3.1 - General Practitioner - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.3.1 - General Practitioner**

## Logical Model: A.3.1 - General Practitioner 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/szz/StructureDefinition/GeneralPractitionerCz | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:LogEnGeneralPractitionerCz |

 
Shared Health Record - Preventive and screening examinations by a general practitioner. 

**Usages:**

* Use this Logical Model: [A.3 - Preventive and screening health record](StructureDefinition-PreventiveAndScreeningRecordCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.szz|current/StructureDefinition/GeneralPractitionerCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-GeneralPractitionerCz.csv), [Excel](StructureDefinition-GeneralPractitionerCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "GeneralPractitionerCz",
  "url" : "https://hl7.cz/fhir/szz/StructureDefinition/GeneralPractitionerCz",
  "version" : "0.0.1",
  "name" : "LogEnGeneralPractitionerCz",
  "title" : "A.3.1 - General Practitioner",
  "status" : "draft",
  "date" : "2025-12-22T12:04:24+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Shared Health Record - Preventive and screening examinations by a general practitioner.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/szz/StructureDefinition/GeneralPractitionerCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "GeneralPractitionerCz",
        "path" : "GeneralPractitionerCz",
        "short" : "A.3.1 - General Practitioner",
        "definition" : "Shared Health Record - Preventive and screening examinations by a general practitioner."
      },
      {
        "id" : "GeneralPractitionerCz.colorectalScreening",
        "path" : "GeneralPractitionerCz.colorectalScreening",
        "short" : "A.3.1.1 - Colorectal cancer screening test result",
        "definition" : "Result of quantitative fecal occult blood test.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "GeneralPractitionerCz.colorectalScreening.resultDate",
        "path" : "GeneralPractitionerCz.colorectalScreening.resultDate",
        "short" : "A.3.1.1.1 - Date of quantitative TOKS result",
        "definition" : "Date on which you evaluate the sample (date on which the FOBT is reported to the health insurance company). Applies to tests evaluated in a doctor's office or laboratory.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "GeneralPractitionerCz.colorectalScreening.resultTOKS",
        "path" : "GeneralPractitionerCz.colorectalScreening.resultTOKS",
        "short" : "A.3.1.1.2 - Quantitative TOKS result (health service code reported to the health insurance company)",
        "definition" : "Health service code reported to the insurance company based on the result of the quantitative TOKS screening.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "GeneralPractitionerCz.colorectalScreening.levelTOKS",
        "path" : "GeneralPractitionerCz.colorectalScreening.levelTOKS",
        "short" : "A.3.1.1.3 - TOKS level",
        "definition" : "Quantitative immunochemical test value (µg/g).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "GeneralPractitionerCz.prostateCancerScreening",
        "path" : "GeneralPractitionerCz.prostateCancerScreening",
        "short" : "A.3.1.2 - Result of prostate cancer screening",
        "definition" : "Categorical result of PSA determination according to value.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "GeneralPractitionerCz.prostateCancerScreening.resultDate",
        "path" : "GeneralPractitionerCz.prostateCancerScreening.resultDate",
        "short" : "A.3.1.2.1 - Date of PSA result",
        "definition" : "Date on which you perform the evaluation (date of reporting the PSA test to the health insurance company).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "GeneralPractitionerCz.prostateCancerScreening.resultPSA",
        "path" : "GeneralPractitionerCz.prostateCancerScreening.resultPSA",
        "short" : "A.3.1.2.2 - Quantitative PSA result (health service code reported to the health insurance company)",
        "definition" : "Health service code reported to the insurance company based on the value of prostate-specific antigen in the patient's blood.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "GeneralPractitionerCz.preventiveCheckUp",
        "path" : "GeneralPractitionerCz.preventiveCheckUp",
        "short" : "A.3.1.3 - Result of examination as part of preventive check-up",
        "definition" : "A.3.1.3 - Result of examination as part of preventive check-up",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "GeneralPractitionerCz.preventiveCheckUp.examinationDate",
        "path" : "GeneralPractitionerCz.preventiveCheckUp.examinationDate",
        "short" : "A.3.1.3.1 - Date of result of preventive check-up performed",
        "definition" : "Date of preventive check-up performed.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "GeneralPractitionerCz.preventiveCheckUp.height",
        "path" : "GeneralPractitionerCz.preventiveCheckUp.height",
        "short" : "A.3.1.3.2 - Height",
        "definition" : "The patient's height in cm.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "GeneralPractitionerCz.preventiveCheckUp.weight",
        "path" : "GeneralPractitionerCz.preventiveCheckUp.weight",
        "short" : "A.3.1.3.3 - Weight",
        "definition" : "The patient's weight in kg.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "GeneralPractitionerCz.preventiveCheckUp.systolicPressure",
        "path" : "GeneralPractitionerCz.preventiveCheckUp.systolicPressure",
        "short" : "A.3.1.3.4 - Pressure (systolic)",
        "definition" : "Value in mm Hg.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "GeneralPractitionerCz.preventiveCheckUp.diastolicPressure",
        "path" : "GeneralPractitionerCz.preventiveCheckUp.diastolicPressure",
        "short" : "A.3.1.3.5 - Pressure (diastolic)",
        "definition" : "Value in mm Hg.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "GeneralPractitionerCz.preventiveCheckUp.waistCircumference",
        "path" : "GeneralPractitionerCz.preventiveCheckUp.waistCircumference",
        "short" : "A.3.1.3.6 - Waist circumference",
        "definition" : "Waist circumference in cm.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      }
    ]
  }
}

```
