# A.3.3 - Gastroenterology - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.3.3 - Gastroenterology**

## Logical Model: A.3.3 - Gastroenterology 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/szz/StructureDefinition/GastroenterologyCz | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:LogEnGastroenterologyCz |

 
Shared Health Record - Screening examination by gastroenterologist. 

**Usages:**

* Use this Logical Model: [A.3 - Preventive and screening health record](StructureDefinition-PreventiveAndScreeningRecordCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.szz|current/StructureDefinition/GastroenterologyCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-GastroenterologyCz.csv), [Excel](StructureDefinition-GastroenterologyCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "GastroenterologyCz",
  "url" : "https://hl7.cz/fhir/szz/StructureDefinition/GastroenterologyCz",
  "version" : "0.0.1",
  "name" : "LogEnGastroenterologyCz",
  "title" : "A.3.3 - Gastroenterology",
  "status" : "draft",
  "date" : "2025-12-22T12:04:24+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Shared Health Record - Screening examination by gastroenterologist.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/szz/StructureDefinition/GastroenterologyCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "GastroenterologyCz",
        "path" : "GastroenterologyCz",
        "short" : "A.3.3 - Gastroenterology",
        "definition" : "Shared Health Record - Screening examination by gastroenterologist."
      },
      {
        "id" : "GastroenterologyCz.colorectalScreening",
        "path" : "GastroenterologyCz.colorectalScreening",
        "short" : "A.3.3.1 - Result of colorectal cancer screening",
        "definition" : "A.3.3.1 - Result of colorectal cancer screening",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "GastroenterologyCz.colorectalScreening.resultDate",
        "path" : "GastroenterologyCz.colorectalScreening.resultDate",
        "short" : "A.3.3.1.1 - Date of colonoscopy result",
        "definition" : "Date of colonoscopy.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "GastroenterologyCz.colorectalScreening.type",
        "path" : "GastroenterologyCz.colorectalScreening.type",
        "short" : "A.3.3.1.2 - Type of colonoscopy performed",
        "definition" : "The patient underwent screening colonoscopy, TOKS+ colonoscopy (i.e., colonoscopy after positive screening TOKS).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "GastroenterologyCz.colorectalScreening.completeness",
        "path" : "GastroenterologyCz.colorectalScreening.completeness",
        "short" : "A.3.3.1.3 - Completeness of the colonoscopy performed",
        "definition" : "The colonoscopy performed was complete (the cecum was reached) or incomplete (the cecum was not reached).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "GastroenterologyCz.colorectalScreening.resultBBPS",
        "path" : "GastroenterologyCz.colorectalScreening.resultBBPS",
        "short" : "A.3.3.1.4 - BBPS result",
        "definition" : "Value 0 to 9 according to the Boston classification (BBPS – Boston Bowel Preparation Scale).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "integer"
          }
        ]
      },
      {
        "id" : "GastroenterologyCz.colorectalScreening.normalFindings",
        "path" : "GastroenterologyCz.colorectalScreening.normalFindings",
        "short" : "A.3.3.1.5 - Colonoscopy result - normal findings",
        "definition" : "The findings of the colonoscopy were normal (no pathology).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "boolean"
          }
        ]
      },
      {
        "id" : "GastroenterologyCz.colorectalScreening.mostSeriousFinding",
        "path" : "GastroenterologyCz.colorectalScreening.mostSeriousFinding",
        "short" : "A.3.3.1.6 - Colonoscopy result - pathology (most serious finding)",
        "definition" : "The most serious pathology found during the colonoscopy.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "GastroenterologyCz.colorectalScreening.numberOfAdenomasOrSerratedLesions",
        "path" : "GastroenterologyCz.colorectalScreening.numberOfAdenomasOrSerratedLesions",
        "short" : "A.3.3.1.7 - Colonoscopy result: pathology (adenomas and serrated lesions)",
        "definition" : "Number of adenomas and serrated lesions (non-hyperplastic) during the colonoscopy.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "integer"
          }
        ]
      },
      {
        "id" : "GastroenterologyCz.colorectalScreening.recommendedProcedure",
        "path" : "GastroenterologyCz.colorectalScreening.recommendedProcedure",
        "short" : "A.3.3.1.8 - Colonoscopy exam.result: Further recomm.examinations",
        "definition" : "Final evaluation of results by physician.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      }
    ]
  }
}

```
