# A.2 - Emergency health record - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2 - Emergency health record**

## Logical Model: A.2 - Emergency health record 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/szz/StructureDefinition/EmergencyRecordCz | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:LogEnEmergencyRecordCz |

 
Shared Health Record - Logical model of Emergency Health Record. 

**Usages:**

* Use this Logical Model: [A - Shared Health Record](StructureDefinition-SzzCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.szz|current/StructureDefinition/EmergencyRecordCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-EmergencyRecordCz.csv), [Excel](StructureDefinition-EmergencyRecordCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "EmergencyRecordCz",
  "url" : "https://hl7.cz/fhir/szz/StructureDefinition/EmergencyRecordCz",
  "version" : "0.0.1",
  "name" : "LogEnEmergencyRecordCz",
  "title" : "A.2 - Emergency health record",
  "status" : "draft",
  "date" : "2025-12-22T12:04:24+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Shared Health Record - Logical model of Emergency Health Record.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/szz/StructureDefinition/EmergencyRecordCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "EmergencyRecordCz",
        "path" : "EmergencyRecordCz",
        "short" : "A.2 - Emergency health record",
        "definition" : "Shared Health Record - Logical model of Emergency Health Record."
      },
      {
        "id" : "EmergencyRecordCz.bloodGroup",
        "path" : "EmergencyRecordCz.bloodGroup",
        "short" : "A.2.1 - Blood Group",
        "definition" : "Information about the patient's blood group.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "EmergencyRecordCz.bloodGroup.bloodType",
        "path" : "EmergencyRecordCz.bloodGroup.bloodType",
        "short" : "A.2.1.1 - Blood Group Type",
        "definition" : "Record of the patient's blood group according to the AB0 system (A, B, AB, 0).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "EmergencyRecordCz.bloodGroup.rhFactor",
        "path" : "EmergencyRecordCz.bloodGroup.rhFactor",
        "short" : "A.2.1.2 - Rh Factor",
        "definition" : "Record of Rh(D) factor.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "EmergencyRecordCz.bloodGroup.testCode",
        "path" : "EmergencyRecordCz.bloodGroup.testCode",
        "short" : "A.2.1.3 - Blood group test code",
        "definition" : "Code identifying the type of blood group test performed.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "EmergencyRecordCz.bloodGroup.dateOfDetection",
        "path" : "EmergencyRecordCz.bloodGroup.dateOfDetection",
        "short" : "A.2.1.4 - Date of blood group detection",
        "definition" : "Date and time when the result was determined.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "EmergencyRecordCz.allergy",
        "path" : "EmergencyRecordCz.allergy",
        "short" : "A.2.2 - Allergies and adverse reactions",
        "definition" : "Record of allergy or other significant adverse reaction to a substance or medicinal product.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "EmergencyRecordCz.allergy.substance",
        "path" : "EmergencyRecordCz.allergy.substance",
        "short" : "A.2.2.1 - Substance - allergen",
        "definition" : "Identification of the substance, medicinal product, or other substance causing the reaction.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "EmergencyRecordCz.allergy.allergenCategory",
        "path" : "EmergencyRecordCz.allergy.allergenCategory",
        "short" : "A.2.2.2 - Allergen category",
        "definition" : "Type of allergen in terms of origin.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "EmergencyRecordCz.allergy.criticality",
        "path" : "EmergencyRecordCz.allergy.criticality",
        "short" : "A.2.2.3 - Criticality",
        "definition" : "Substance, group of substances, or environmental factor to which the patient is allergic or hypersensitive. The causative agent can be expressed using a substance code, ATC group, or SÚKL product code (in the case of medicinal products).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "EmergencyRecordCz.allergy.reactionType",
        "path" : "EmergencyRecordCz.allergy.reactionType",
        "short" : "A.2.2.4 - Reaction type",
        "definition" : "Information on whether it is an allergy or intolerance.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "EmergencyRecordCz.allergy.manifestation",
        "path" : "EmergencyRecordCz.allergy.manifestation",
        "short" : "A.2.2.5 - Manifestation",
        "definition" : "Clinical manifestations of the reaction.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "EmergencyRecordCz.allergy.severityReaction",
        "path" : "EmergencyRecordCz.allergy.severityReaction",
        "short" : "A.2.2.6 - Clinical severity of manifestation",
        "definition" : "Clinical severity of manifestation.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "EmergencyRecordCz.allergy.dateOfDetection",
        "path" : "EmergencyRecordCz.allergy.dateOfDetection",
        "short" : "A.2.2.7 - Date of detection",
        "definition" : "Date when the allergy/reaction was first diagnosed (onset).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "EmergencyRecordCz.allergy.recordOriginator",
        "path" : "EmergencyRecordCz.allergy.recordOriginator",
        "short" : "A.2.2.8 - Record originator",
        "definition" : "Healthcare provider who recorded the data.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "EmergencyRecordCz.otherEmergencyData",
        "path" : "EmergencyRecordCz.otherEmergencyData",
        "short" : "A.2.3 - Other emergency data",
        "definition" : "Other data includes records of significant adverse events. These typically include adverse drug reactions, transfusion reactions, complications during the administration of blood products, etc.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "EmergencyRecordCz.otherEmergencyData.eventType",
        "path" : "EmergencyRecordCz.otherEmergencyData.eventType",
        "short" : "A.2.3.1 - Event type",
        "definition" : "Classification of the event (e.g., adverse drug reaction, transfusion reaction).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "EmergencyRecordCz.otherEmergencyData.suspectedSubstance",
        "path" : "EmergencyRecordCz.otherEmergencyData.suspectedSubstance",
        "short" : "A.2.3.2. - Suspected substance",
        "definition" : "A substance, drug, or other factor suspected of causing the event.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "EmergencyRecordCz.otherEmergencyData.dateOfDiscovery",
        "path" : "EmergencyRecordCz.otherEmergencyData.dateOfDiscovery",
        "short" : "A.2.3.3 - Date of discovery",
        "definition" : "Date and time when the adverse event occurred.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "EmergencyRecordCz.otherEmergencyData.recordOriginator",
        "path" : "EmergencyRecordCz.otherEmergencyData.recordOriginator",
        "short" : "A.2.3.4 - Record originator",
        "definition" : "Healthcare provider who recorded the data.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "EmergencyRecordCz.usedMedication",
        "path" : "EmergencyRecordCz.usedMedication",
        "short" : "A.2.4 - Medicinal products used in the provision of healthcare services by inpatient care providers",
        "definition" : "Medicinal products used in the patient during the provision of healthcare services by inpatient care providers over the last 12 months.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "EmergencyRecordCz.usedMedication.identification",
        "path" : "EmergencyRecordCz.usedMedication.identification",
        "short" : "A.3.4.1 - Identification of medicinal product",
        "definition" : "Code of the medicinal product administered to the patient during hospitalization.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "EmergencyRecordCz.usedMedication.quantity",
        "path" : "EmergencyRecordCz.usedMedication.quantity",
        "short" : "A.3.4.2 - Quantity",
        "definition" : "The quantity of the medicinal product administered.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "EmergencyRecordCz.usedMedication.dateOfAdministration",
        "path" : "EmergencyRecordCz.usedMedication.dateOfAdministration",
        "short" : "A.2.4.3 - Date of administration",
        "definition" : "The date and time when the medicinal product was administered to the patient in an inpatient facility.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "EmergencyRecordCz.usedMedication.sourceOfRecord",
        "path" : "EmergencyRecordCz.usedMedication.sourceOfRecord",
        "short" : "A.2.4.4 - Source of record",
        "definition" : "The provider who recorded the data – inpatient facility.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      }
    ]
  }
}

```
