# A.1.7 - Digital signature - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.1.7 - Digital signature**

## Logical Model: A.1.7 - Digital signature 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/szz/StructureDefinition/DigitalSignatureCz | *Version*:0.0.1 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogEnDigitalSignatureCz |

 
Shared Health Record - Electronic signature or seal of a document according to Act 327/2011 §54a 

**Usages:**

* Use this Logical Model: [A.1 - Document header](StructureDefinition-HeaderSzzCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.szz|current/StructureDefinition/DigitalSignatureCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-DigitalSignatureCz.csv), [Excel](StructureDefinition-DigitalSignatureCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "DigitalSignatureCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/szz/StructureDefinition/DigitalSignatureCz",
  "version" : "0.0.1",
  "name" : "LogEnDigitalSignatureCz",
  "title" : "A.1.7 - Digital signature",
  "status" : "draft",
  "date" : "2025-12-22T12:04:24+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Shared Health Record - Electronic signature or seal of a document according to Act 327/2011 §54a",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/szz/StructureDefinition/DigitalSignatureCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "DigitalSignatureCz",
        "path" : "DigitalSignatureCz",
        "short" : "A.1.7 - Digital signature",
        "definition" : "Shared Health Record - Electronic signature or seal of a document according to Act 327/2011 §54a"
      },
      {
        "id" : "DigitalSignatureCz.digitalSignature",
        "path" : "DigitalSignatureCz.digitalSignature",
        "short" : "A.1.7.1 - Electronic signature or document seal",
        "definition" : "Electronic signature or document seal.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Signature"
          }
        ]
      },
      {
        "id" : "DigitalSignatureCz.timestamp",
        "path" : "DigitalSignatureCz.timestamp",
        "short" : "A.1.7.2 - Electronic time stamp",
        "definition" : "Electronic time stamp",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "instant"
          }
        ]
      }
    ]
  }
}

```
