# A.3.5 - Biochemistry Lab - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.3.5 - Biochemistry Lab**

## Logical Model: A.3.5 - Biochemistry Lab 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/szz/StructureDefinition/BiochemistryLabCz | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:LogEnBiochemistryLabCz |

 
Shared Health Record - Screenings performed by the Biochemical Laboratory. 

**Usages:**

* Use this Logical Model: [A.3 - Preventive and screening health record](StructureDefinition-PreventiveAndScreeningRecordCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.szz|current/StructureDefinition/BiochemistryLabCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-BiochemistryLabCz.csv), [Excel](StructureDefinition-BiochemistryLabCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "BiochemistryLabCz",
  "url" : "https://hl7.cz/fhir/szz/StructureDefinition/BiochemistryLabCz",
  "version" : "0.0.1",
  "name" : "LogEnBiochemistryLabCz",
  "title" : "A.3.5 - Biochemistry Lab",
  "status" : "draft",
  "date" : "2025-12-22T12:04:24+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Shared Health Record - Screenings performed by the Biochemical Laboratory.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/szz/StructureDefinition/BiochemistryLabCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "BiochemistryLabCz",
        "path" : "BiochemistryLabCz",
        "short" : "A.3.5 - Biochemistry Lab",
        "definition" : "Shared Health Record - Screenings performed by the Biochemical Laboratory."
      },
      {
        "id" : "BiochemistryLabCz.colorectalScreening",
        "path" : "BiochemistryLabCz.colorectalScreening",
        "short" : "A.3.5.1 - Colorectal cancer screening test result",
        "definition" : "Result of quantitative fecal occult blood test.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "BiochemistryLabCz.colorectalScreening.resultDate",
        "path" : "BiochemistryLabCz.colorectalScreening.resultDate",
        "short" : "A.3.5.1.1 - Date of quantitative TOKS result",
        "definition" : "Date on which you evaluate the sample (date on which the TOKS result is reported to the health insurance company).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "BiochemistryLabCz.colorectalScreening.levelTOKS",
        "path" : "BiochemistryLabCz.colorectalScreening.levelTOKS",
        "short" : "A.3.5.1.2 - TOKS level",
        "definition" : "Quantitative immunochemical test value (µg/g).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "BiochemistryLabCz.prostateCancerScreening",
        "path" : "BiochemistryLabCz.prostateCancerScreening",
        "short" : "A.3.5.2 - Result of prostate cancer screening",
        "definition" : "A.3.5.2 - Result of prostate cancer screening",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "BiochemistryLabCz.prostateCancerScreening.analysisDate",
        "path" : "BiochemistryLabCz.prostateCancerScreening.analysisDate",
        "short" : "A.3.5.2.1 - Date of PSA analysis",
        "definition" : "Date of blood sample analysis for examination.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "BiochemistryLabCz.prostateCancerScreening.levelPSA",
        "path" : "BiochemistryLabCz.prostateCancerScreening.levelPSA",
        "short" : "A.3.5.2.2 - PSA level",
        "definition" : "PSA level in μg/l (specific number).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      }
    ]
  }
}

```
