# Patient Mrakomorová - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Patient Mrakomorová**

## Example Patient: Patient Mrakomorová

Profile: [Patient (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)

Mračena Mrakomorová Female, DoB: 1988-02-12 ( https://ncez.mzcr.cz/fhir/sid/cpoj#0551621111 (use: official, ))

-------

| | |
| :--- | :--- |
| Other Id: | `https://ncez.mzcr.cz/fhir/sid/rid`/2066425388 |
| Contact Detail | Na Náměstí 16, 190 00 Praha 9 - Prosek(home) |
| Language: | Czech(preferred) |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "cb1344a1-ee6e-45b3-a6b4-c3eacae4ddec",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
    ]
  },
  "identifier" : [
    {
      "system" : "https://ncez.mzcr.cz/fhir/sid/rid",
      "value" : "2066425388"
    },
    {
      "use" : "official",
      "system" : "https://ncez.mzcr.cz/fhir/sid/cpoj",
      "value" : "0551621111"
    }
  ],
  "name" : [
    {
      "use" : "usual",
      "family" : "Mrakomorová",
      "given" : ["Mračena"],
      "prefix" : ["Bc."]
    }
  ],
  "gender" : "female",
  "birthDate" : "1988-02-12",
  "address" : [
    {
      "use" : "home",
      "type" : "physical",
      "text" : "Na Náměstí 16, 190 00 Praha 9 - Prosek",
      "line" : ["Na Náměstí 16"],
      "_line" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
              "valueString" : "Na Náměstí"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
              "valueString" : "16"
            }
          ]
        }
      ],
      "city" : "Praha",
      "postalCode" : "19000",
      "country" : "CZ",
      "_country" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-SC-coding",
            "valueCoding" : {
              "system" : "urn:iso:std:iso:3166",
              "code" : "CZ",
              "display" : "Czechia"
            }
          }
        ]
      }
    }
  ],
  "communication" : [
    {
      "language" : {
        "coding" : [
          {
            "system" : "urn:ietf:bcp:47",
            "code" : "cs"
          }
        ]
      },
      "preferred" : true
    }
  ]
}

```
