# Observation: Lung cancer - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Observation: Lung cancer**

## Example Observation: Observation: Lung cancer

Profile: [Observation: Lung cancer (SZZ CZ)](StructureDefinition-cz-observation-lung-cancer.md)

**status**: Final

**category**: Imaging

**code**: Computed tomography

**subject**: [Mračena Mrakomorová Female, DoB: 1988-02-12 ( https://ncez.mzcr.cz/fhir/sid/cpoj#0551621111 (use: official, ))](Bundle-cz-example-bundle-screeningrecord-2.md#urn-uuid-cb1344a1-ee6e-45b3-a6b4-c3eacae4ddec)

**effective**: 2024-04-14 10:30:00+0100

**performer**: [PractitionerRole: specialty = Radiology](Bundle-cz-example-bundle-screeningrecord-2.md#urn-uuid-2a06ef57-f377-4031-a098-612aa44f54b2)

**value**: neurčitý

**interpretation**: Kontrolní LDCT za 6-8 týdnů

### Components

| | | |
| :--- | :--- | :--- |
| - | **Code** | **Value[x]** |
| * | CT of lungs | vstupní |



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "f564cd9a-422f-439b-ae17-b2c0a1311ead",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-lung-cancer"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "imaging"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "77477000",
        "display" : "Computed tomography"
      }
    ]
  },
  "subject" : {
    "reference" : "urn:uuid:cb1344a1-ee6e-45b3-a6b4-c3eacae4ddec"
  },
  "effectiveDateTime" : "2024-04-14T10:30:00+01:00",
  "performer" : [
    {
      "reference" : "urn:uuid:2a06ef57-f377-4031-a098-612aa44f54b2"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-result-lung-cancer-cs",
        "code" : "neurcity",
        "display" : "neurčitý"
      }
    ]
  },
  "interpretation" : [
    {
      "coding" : [
        {
          "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-lung-cancer-interpretation-cs",
          "code" : "ldctza6w",
          "display" : "Kontrolní LDCT za 6-8 týdnů"
        }
      ]
    }
  ],
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "241540006",
            "display" : "CT of lungs"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-type-lung-cancer-observation-cs",
            "code" : "vstupni",
            "display" : "vstupní"
          }
        ]
      }
    }
  ]
}

```
