# Observation: Colonoscopy Example (CZ) - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Observation: Colonoscopy Example (CZ)**

## Example Observation: Observation: Colonoscopy Example (CZ)

Profile: [Observation: Colonoscopy (SZZ CZ)](StructureDefinition-cz-observation-colonoscopy.md)

**status**: Final

**category**: Imaging

**code**: Colonoscopy

**subject**: [Králík Pokusný Male, DoB: 1985-01-12 ( https://ncez.mzcr.cz/fhir/sid/cpoj#0551621110 (use: official, ))](Bundle-cz-example-bundle-screeningrecord.md#urn-uuid-fe858e7c-ba5f-4641-9878-7c6c4790634f)

**effective**: 2025-12-10 10:30:00+0100

**performer**: [PractitionerRole: specialty = Radiology](Bundle-cz-example-bundle-screeningrecord.md#urn-uuid-38e5929e-afe4-40bc-ba9d-c0a80549791e)

**interpretation**: dispenzární koloskopie za 6 měsíců

> **component****code**:Procedure type**value**:TOKS+

> **component****code**:Boston bowel preparation scale**value**: 9

> **component****code**:Colonoscopy normal**value**: true



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "cd2b65ad-9926-4589-98c9-7e581e21602a",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-colonoscopy"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "imaging"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "73761001"
      }
    ]
  },
  "subject" : {
    "reference" : "urn:uuid:fe858e7c-ba5f-4641-9878-7c6c4790634f"
  },
  "effectiveDateTime" : "2025-12-10T10:30:00+01:00",
  "performer" : [
    {
      "reference" : "urn:uuid:38e5929e-afe4-40bc-ba9d-c0a80549791e"
    }
  ],
  "interpretation" : [
    {
      "coding" : [
        {
          "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-colonoscopy-interpretation",
          "code" : "kolonoskopie6mes",
          "display" : "dispenzární koloskopie za 6 měsíců"
        }
      ]
    }
  ],
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "276218009",
            "display" : "Procedure type"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-colonoscopy-type-cs",
            "code" : "toks",
            "display" : "TOKS+"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "722818007",
            "display" : "Boston bowel preparation scale"
          }
        ]
      },
      "valueInteger" : 9
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "313170008",
            "display" : "Colonoscopy normal"
          }
        ]
      },
      "valueBoolean" : true
    }
  ]
}

```
