# Observation: Waist circumference Example (CZ) - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Observation: Waist circumference Example (CZ)**

## Example Observation: Observation: Waist circumference Example (CZ)

Profile: [Observation: Waist circumference (SZZ CZ)](StructureDefinition-cz-waist-circumference.md)

**status**: Final

**category**: Vital Signs

**code**: Waist Circumference at umbilicus by Tape measure

**subject**: [Mračena Mrakomorová Female, DoB: 1988-02-12 ( https://ncez.mzcr.cz/fhir/sid/cpoj#0551621111 (use: official, ))](Bundle-cz-example-bundle-screeningrecord-2.md#urn-uuid-cb1344a1-ee6e-45b3-a6b4-c3eacae4ddec)

**effective**: 2025-05-15 10:35:00+0100

**performer**: [PractitionerRole: specialty = Radiology](Bundle-cz-example-bundle-screeningrecord-2.md#urn-uuid-2a06ef57-f377-4031-a098-612aa44f54b2)

**value**: 100 cm



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "82451f85-ee50-4367-b809-0511ea469269",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/szz/StructureDefinition/cz-waist-circumference"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "vital-signs"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "8280-0"
      }
    ]
  },
  "subject" : {
    "reference" : "urn:uuid:cb1344a1-ee6e-45b3-a6b4-c3eacae4ddec"
  },
  "effectiveDateTime" : "2025-05-15T10:35:00+01:00",
  "performer" : [
    {
      "reference" : "urn:uuid:2a06ef57-f377-4031-a098-612aa44f54b2"
    }
  ],
  "valueQuantity" : {
    "value" : 100,
    "unit" : "cm",
    "system" : "http://unitsofmeasure.org"
  }
}

```
