# Observation Blood Type for Patient Králík - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Observation Blood Type for Patient Králík**

## Example Observation: Observation Blood Type for Patient Králík

Profile: [Observation: Blood Type (SZZ CZ)](StructureDefinition-cz-observation-blood-type.md)

**status**: Final

**code**: Krevní skupina AB0 RhD kompletní (B; přítomnost [-] Aglutinace (gel))

**subject**: [Králík Pokusný Male, DoB: 1985-01-12 ( https://ncez.mzcr.cz/fhir/sid/cpoj#0551621110 (use: official, ))](Bundle-cz-example-bundle-emergencyrecord.md#urn-uuid-142534ac-0274-4a16-b6a2-d4d4f24ff67b)

**effective**: 2025-10-20 10:30:00+0100

**performer**: [PractitionerRole: specialty = Radiology](Bundle-cz-example-bundle-emergencyrecord.md#urn-uuid-428025b5-e328-4542-8812-dd6a874c44f9)

**value**: Blood group A



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "5da80cc6-b699-42dc-aeba-86e229063975",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-blood-type"
    ]
  },
  "status" : "final",
  "code" : {
    "coding" : [
      {
        "system" : "https://nclp.ncez.mzcr.cz/CodeSystem/nclppol",
        "code" : "05162",
        "display" : "Krevní skupina AB0 RhD kompletní (B; přítomnost [-] Aglutinace (gel))"
      }
    ]
  },
  "subject" : {
    "reference" : "urn:uuid:142534ac-0274-4a16-b6a2-d4d4f24ff67b"
  },
  "effectiveDateTime" : "2025-10-20T10:30:00+01:00",
  "performer" : [
    {
      "reference" : "urn:uuid:428025b5-e328-4542-8812-dd6a874c44f9"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "112144000",
        "display" : "Blood group A"
      }
    ]
  }
}

```
