# Observation: Body Height Example (CZ) - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Observation: Body Height Example (CZ)**

## Example Observation: Observation: Body Height Example (CZ)

Profile: [Observation: Height (SZZ CZ)](StructureDefinition-cz-bodyheight.md)

**status**: Final

**category**: Vital Signs

**code**: Body height

**subject**: [Králík Pokusný Male, DoB: 1985-01-12 ( https://ncez.mzcr.cz/fhir/sid/cpoj#0551621110 (use: official, ))](Bundle-cz-example-bundle-screeningrecord.md#urn-uuid-fe858e7c-ba5f-4641-9878-7c6c4790634f)

**effective**: 2025-05-15 10:30:00+0100

**performer**: [PractitionerRole: specialty = Radiology](Bundle-cz-example-bundle-screeningrecord.md#urn-uuid-38e5929e-afe4-40bc-ba9d-c0a80549791e)

**value**: 180 cm(Details: UCUM codecm = 'cm')



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "5031be23-9628-49af-8cac-d23ea87cb8e0",
  "meta" : {
    "profile" : ["https://hl7.cz/fhir/szz/StructureDefinition/cz-bodyheight"]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "vital-signs"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "8302-2"
      },
      {
        "system" : "https://nclp.ncez.mzcr.cz/CodeSystem/nclppol",
        "code" : "20411"
      },
      {
        "system" : "http://snomed.info/sct",
        "code" : "1153637007"
      }
    ]
  },
  "subject" : {
    "reference" : "urn:uuid:fe858e7c-ba5f-4641-9878-7c6c4790634f"
  },
  "effectiveDateTime" : "2025-05-15T10:30:00+01:00",
  "performer" : [
    {
      "reference" : "urn:uuid:38e5929e-afe4-40bc-ba9d-c0a80549791e"
    }
  ],
  "valueQuantity" : {
    "value" : 180,
    "unit" : "cm",
    "system" : "http://unitsofmeasure.org",
    "code" : "cm"
  }
}

```
