# Observation: Cytology cervical cancer - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Observation: Cytology cervical cancer**

## Example Observation: Observation: Cytology cervical cancer

Profile: [Observation: Cervical Cancer Cytology Screening (SZZ CZ)](StructureDefinition-cz-observation-cytology-cervical-cancer.md)

**status**: Final

**category**: Laboratory

**code**: Screening techniques [Identifier] in Cervical or vaginal smear or scraping by Cyto stain

**subject**: [Mračena Mrakomorová Female, DoB: 1988-02-12 ( https://ncez.mzcr.cz/fhir/sid/cpoj#0551621111 (use: official, ))](Bundle-cz-example-bundle-screeningrecord-2.md#urn-uuid-cb1344a1-ee6e-45b3-a6b4-c3eacae4ddec)

**effective**: 2025-07-15 10:30:00+0100

**performer**: [PractitionerRole: specialty = Radiology](Bundle-cz-example-bundle-screeningrecord-2.md#urn-uuid-2a06ef57-f377-4031-a098-612aa44f54b2)

**value**: Abnormální nález



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "40ee0269-0027-4e7b-b061-e039c06cf988",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-cytology-cervical-cancer"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "19771-5"
      }
    ]
  },
  "subject" : {
    "reference" : "urn:uuid:cb1344a1-ee6e-45b3-a6b4-c3eacae4ddec"
  },
  "effectiveDateTime" : "2025-07-15T10:30:00+01:00",
  "performer" : [
    {
      "reference" : "urn:uuid:2a06ef57-f377-4031-a098-612aa44f54b2"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-cervical-cancer-cytology-result-cs",
        "code" : "abnormalni",
        "display" : "Abnormální nález"
      }
    ]
  }
}

```
