# Observation: Pulmonology - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Observation: Pulmonology**

## Example Observation: Observation: Pulmonology

Profile: [Observation: Pulmonology (SZZ CZ)](StructureDefinition-cz-observation-pulmonology.md)

**status**: Final

**category**: Exam

**code**: Lung finding

**subject**: [Mračena Mrakomorová Female, DoB: 1988-02-12 ( https://ncez.mzcr.cz/fhir/sid/cpoj#0551621111 (use: official, ))](Bundle-cz-example-bundle-screeningrecord-2.md#urn-uuid-cb1344a1-ee6e-45b3-a6b4-c3eacae4ddec)

**effective**: 2024-04-14 10:30:00+0100

**performer**: [PractitionerRole: specialty = Radiology](Bundle-cz-example-bundle-screeningrecord-2.md#urn-uuid-2a06ef57-f377-4031-a098-612aa44f54b2)

**interpretation**: Doporučení screeningového LDCT plic - ano

> **component****code**:Finding of tobacco smoking behavior**value**:exkuřák (přestal před více než měsícem)

> **component****code**:Stopped smoking**value**: 2

> **component****code**:Tobacco smoking consumption**value**: 10

> **component****code**:Number of calculated smoking pack years**value**: 20

> **component****code**:Physical examination**value**:patologický poslechový nález

> **component****code**:Functional assessment**value**:nespecifikovaná porucha

> **component****code**:Plain chest X-ray**value**:patologický nález



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "407b583e-4c05-47eb-b0df-6d8166c0d4f1",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-pulmonology"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "exam"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "301230006",
        "display" : "Lung finding"
      }
    ]
  },
  "subject" : {
    "reference" : "urn:uuid:cb1344a1-ee6e-45b3-a6b4-c3eacae4ddec"
  },
  "effectiveDateTime" : "2024-04-14T10:30:00+01:00",
  "performer" : [
    {
      "reference" : "urn:uuid:2a06ef57-f377-4031-a098-612aa44f54b2"
    }
  ],
  "interpretation" : [
    {
      "coding" : [
        {
          "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-pulmonology-interpretation-cs",
          "code" : "recommended",
          "display" : "Doporučení screeningového LDCT plic - ano"
        }
      ]
    }
  ],
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "365981007",
            "display" : "Finding of tobacco smoking behavior"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-tobacco-history-cs",
            "code" : "exsmoker",
            "display" : "exkuřák (přestal před více než měsícem)"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "160617001",
            "display" : "Stopped smoking"
          }
        ]
      },
      "valueInteger" : 2
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "266918002",
            "display" : "Tobacco smoking consumption"
          }
        ]
      },
      "valueInteger" : 10
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "782516008",
            "display" : "Number of calculated smoking pack years"
          }
        ]
      },
      "valueInteger" : 20
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "5880005",
            "display" : "Physical examination"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-physical-examination-pulmonology-result-cs",
            "code" : "patological",
            "display" : "patologický poslechový nález"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "12894003",
            "display" : "Functional assessment"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-functional-examination-pulmonology-result-cs",
            "code" : "nespecificDisorder",
            "display" : "nespecifikovaná porucha"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "399208008",
            "display" : "Plain chest X-ray"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-pulmonology-result-cs",
            "code" : "pathological",
            "display" : "patologický nález"
          }
        ]
      }
    }
  ]
}

```
