# Observation: Mammography - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Observation: Mammography**

## Example Observation: Observation: Mammography

Profile: [Observation: Mammography (SZZ CZ)](StructureDefinition-cz-observation-mammography.md)

**status**: Final

**category**: Imaging

**code**: Mammography

**subject**: [Mračena Mrakomorová Female, DoB: 1988-02-12 ( https://ncez.mzcr.cz/fhir/sid/cpoj#0551621111 (use: official, ))](Bundle-cz-example-bundle-screeningrecord-2.md#urn-uuid-cb1344a1-ee6e-45b3-a6b4-c3eacae4ddec)

**effective**: 2025-04-14 10:30:00+0100

**performer**: [PractitionerRole: specialty = Radiology](Bundle-cz-example-bundle-screeningrecord-2.md#urn-uuid-2a06ef57-f377-4031-a098-612aa44f54b2)

**value**: nejednoznačný nález - potřeba dalšího vyšetření

> **component****code**:Klasifikace dle Tabára**value**:Tabár IV

> **component****code**:Klasifikace dle BiRADS**value**:BIRADS D



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "0a3b5d6a-e9a8-4aa2-bcff-7c916540bf08",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-mammography"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "imaging"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "71651007",
        "display" : "Mammography"
      }
    ]
  },
  "subject" : {
    "reference" : "urn:uuid:cb1344a1-ee6e-45b3-a6b4-c3eacae4ddec"
  },
  "effectiveDateTime" : "2025-04-14T10:30:00+01:00",
  "performer" : [
    {
      "reference" : "urn:uuid:2a06ef57-f377-4031-a098-612aa44f54b2"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-result-mammography-cs",
        "code" : "1",
        "display" : "nejednoznačný nález - potřeba dalšího vyšetření"
      }
    ]
  },
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-density-type-cs",
            "code" : "tabar",
            "display" : "Klasifikace dle Tabára"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-tabar-density-cs",
            "code" : "4",
            "display" : "Tabár IV"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-density-type-cs",
            "code" : "birads",
            "display" : "Klasifikace dle BiRADS"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-birads-density-cs",
            "code" : "40",
            "display" : "BIRADS D"
          }
        ]
      }
    }
  ]
}

```
