# Composition: Emergency Report (CZ) - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Composition: Emergency Report (CZ)**

## Example Composition: Composition: Emergency Report (CZ)

Language: cs

Profile: [Composition (SZZ CZ)](StructureDefinition-cz-composition-sharedhealthrecord.md)

**identifier**: `http://example.org/myhospital/reportidentifiers`/dfkjewoieoijwoskdjg

**status**: Final

**type**: History and physical note

**date**: 2025-05-20 12:02:00+0100

**author**: [PractitionerRole: specialty = Radiology](Bundle-cz-example-bundle-emergencyrecord.md#urn-uuid-428025b5-e328-4542-8812-dd6a874c44f9)

**title**: Shared Health Record - Emergency Report for patient Ing. Králíka

**confidentiality**: normal

**custodian**: [Organization Fakultní nemocnice Oblackov](Bundle-cz-example-bundle-emergencyrecord.md#urn-uuid-f84d821c-ba13-412b-a340-2547a6f36b7f)



## Resource Content

```json
{
  "resourceType" : "Composition",
  "id" : "f711d704-df5c-4599-ac80-e8636e0f9931",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/szz/StructureDefinition/cz-composition-sharedhealthrecord"
    ]
  },
  "language" : "cs",
  "identifier" : {
    "system" : "http://example.org/myhospital/reportidentifiers",
    "value" : "dfkjewoieoijwoskdjg"
  },
  "status" : "final",
  "type" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "34117-2",
        "display" : "History and physical note"
      }
    ]
  },
  "subject" : {
    "reference" : "urn:uuid:142534ac-0274-4a16-b6a2-d4d4f24ff67b"
  },
  "date" : "2025-05-20T12:02:00+01:00",
  "author" : [
    {
      "reference" : "urn:uuid:428025b5-e328-4542-8812-dd6a874c44f9"
    }
  ],
  "title" : "Shared Health Record  - Emergency Report for patient Ing. Králíka",
  "confidentiality" : "N",
  "custodian" : {
    "reference" : "urn:uuid:f84d821c-ba13-412b-a340-2547a6f36b7f"
  },
  "section" : [
    {
      "title" : "Emergency Record",
      "code" : {
        "coding" : [
          {
            "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-document-section-szz-cs",
            "code" : "10001",
            "display" : "Emergency health record"
          }
        ]
      },
      "entry" : [
        {
          "reference" : "urn:uuid:5da80cc6-b699-42dc-aeba-86e229063975"
        },
        {
          "reference" : "urn:uuid:4b343429-16da-4a5b-be80-17e4122f5956"
        },
        {
          "reference" : "urn:uuid:74d87d39-d681-4df4-80a5-975b359e6210"
        },
        {
          "reference" : "urn:uuid:ce0f692f-0461-4ed0-8df3-f8db265f755c"
        }
      ]
    }
  ]
}

```
