# Composition: Screening Report (CZ) - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Composition: Screening Report (CZ)**

## Example Composition: Composition: Screening Report (CZ)

Language: cs

Profile: [Composition (SZZ CZ)](StructureDefinition-cz-composition-sharedhealthrecord.md)

**identifier**: `http://example.org/myhospital/reportidentifiers`/dfkjewoieoijwoskdjg

**status**: Final

**type**: History and physical note

**date**: 2025-05-20 12:02:00+0100

**author**: [PractitionerRole: specialty = Radiology](Bundle-cz-example-bundle-screeningrecord.md#urn-uuid-38e5929e-afe4-40bc-ba9d-c0a80549791e)

**title**: Shared Health Record - Emergency Report for patient Ing. Králíka

**confidentiality**: normal

**custodian**: [Organization Fakultní nemocnice Oblackov](Bundle-cz-example-bundle-screeningrecord.md#urn-uuid-2ef3f712-d586-4b3e-92eb-6a5bddc58a68)



## Resource Content

```json
{
  "resourceType" : "Composition",
  "id" : "91795ef9-ba97-4712-95b4-177f1d784066",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/szz/StructureDefinition/cz-composition-sharedhealthrecord"
    ]
  },
  "language" : "cs",
  "identifier" : {
    "system" : "http://example.org/myhospital/reportidentifiers",
    "value" : "dfkjewoieoijwoskdjg"
  },
  "status" : "final",
  "type" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "34117-2",
        "display" : "History and physical note"
      }
    ]
  },
  "subject" : {
    "reference" : "urn:uuid:fe858e7c-ba5f-4641-9878-7c6c4790634f"
  },
  "date" : "2025-05-20T12:02:00+01:00",
  "author" : [
    {
      "reference" : "urn:uuid:38e5929e-afe4-40bc-ba9d-c0a80549791e"
    }
  ],
  "title" : "Shared Health Record  - Emergency Report for patient Ing. Králíka",
  "confidentiality" : "N",
  "custodian" : {
    "reference" : "urn:uuid:2ef3f712-d586-4b3e-92eb-6a5bddc58a68"
  },
  "section" : [
    {
      "title" : "Preventive and screening health record",
      "code" : {
        "coding" : [
          {
            "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-document-section-szz-cs",
            "code" : "10002",
            "display" : "Preventive and screening health record"
          }
        ]
      },
      "section" : [
        {
          "title" : "General practitioner record",
          "code" : {
            "coding" : [
              {
                "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-document-section-szz-cs",
                "code" : "10003",
                "display" : "General practitioner record"
              }
            ]
          },
          "entry" : [
            {
              "reference" : "urn:uuid:8a6733be-e107-44b6-99a8-77869faea42a"
            },
            {
              "reference" : "urn:uuid:d87b5700-f89c-444b-8360-29c9f7673bf1"
            },
            {
              "reference" : "urn:uuid:5031be23-9628-49af-8cac-d23ea87cb8e0"
            },
            {
              "reference" : "urn:uuid:02f3d1a4-4a5c-42ae-9f68-ba2f7dfe88a8"
            },
            {
              "reference" : "urn:uuid:824055fa-6107-49c8-b217-f029aa7b8872"
            }
          ]
        },
        {
          "title" : "Results of colorectal cancer screening tests",
          "code" : {
            "coding" : [
              {
                "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-document-section-szz-cs",
                "code" : "10008",
                "display" : "Gastroenterology record"
              }
            ]
          },
          "entry" : [
            {
              "reference" : "urn:uuid:cd2b65ad-9926-4589-98c9-7e581e21602a"
            }
          ]
        },
        {
          "title" : "Results of biochemistry laboratory tests",
          "code" : {
            "coding" : [
              {
                "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-document-section-szz-cs",
                "code" : "10005",
                "display" : "Biochemistry laboratory record"
              }
            ]
          },
          "entry" : [
            {
              "reference" : "urn:uuid:02f3d1a4-4a5c-42ae-9f68-ba2f7dfe88a8"
            },
            {
              "reference" : "urn:uuid:824055fa-6107-49c8-b217-f029aa7b8872"
            }
          ]
        },
        {
          "title" : "Results of imaging observation",
          "code" : {
            "coding" : [
              {
                "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-document-section-szz-cs",
                "code" : "10009",
                "display" : "Radiology record"
              }
            ]
          },
          "entry" : [
            {
              "reference" : "urn:uuid:76879fde-d561-4435-b119-6bb579bea0f5"
            }
          ]
        },
        {
          "title" : "Result of urology observations",
          "code" : {
            "coding" : [
              {
                "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-document-section-szz-cs",
                "code" : "10006",
                "display" : "Urology record"
              }
            ]
          },
          "entry" : [
            {
              "reference" : "urn:uuid:824055fa-6107-49c8-b217-f029aa7b8872"
            },
            {
              "reference" : "urn:uuid:57838f4e-238c-43e4-9088-42971d8171a6"
            },
            {
              "reference" : "urn:uuid:bc143cd8-4638-4823-87d5-6bc16ce68e85"
            }
          ]
        }
      ]
    }
  ]
}

```
