# Urology interpretation Code System - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Urology interpretation Code System**

## CodeSystem: Urology interpretation Code System 

| | |
| :--- | :--- |
| *Official URL*:https://ncez.mzcr.cz/terminology/CodeSystem/cz-urology-interpretation-cs | *Version*:0.0.1 |
| Active as of 2025-12-09 | *Computable Name*:UrologyInterpretationCS |

 
Urology interpretation code system 

 This Code system is referenced in the content logical definition of the following value sets: 

* [UrologyInterpretationVS](ValueSet-cz-urology-interpretation-vs.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "cz-urology-interpretation-cs",
  "language" : "cs",
  "url" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-urology-interpretation-cs",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986"
    }
  ],
  "version" : "0.0.1",
  "name" : "UrologyInterpretationCS",
  "title" : "Urology interpretation Code System",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-09",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Urology interpretation code system",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 4,
  "concept" : [
    {
      "code" : "screening",
      "display" : "návrat do screeningu"
    },
    {
      "code" : "urologyControl",
      "display" : "kontrolní urologické vyšetření"
    },
    {
      "code" : "mriwithout",
      "display" : "MRI bez podání kontrastní látky"
    },
    {
      "code" : "mriwith",
      "display" : "MRI s kontrastní látkou /biopsie"
    }
  ]
}

```
