# Mammography Result Code System - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Mammography Result Code System**

## CodeSystem: Mammography Result Code System 

| | |
| :--- | :--- |
| *Official URL*:https://ncez.mzcr.cz/terminology/CodeSystem/cz-result-mammography-cs | *Version*:0.0.1 |
| Active as of 2025-12-04 | *Computable Name*:ResultMamographyCS |

 
Mammography result code system 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ResultMamographyVs](ValueSet-cz-result-mammography-vs.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "cz-result-mammography-cs",
  "language" : "cs",
  "url" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-result-mammography-cs",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986"
    }
  ],
  "version" : "0.0.1",
  "name" : "ResultMamographyCS",
  "title" : "Mammography Result Code System",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-04",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Mammography result code system",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 12,
  "concept" : [
    {
      "code" : "1",
      "display" : "nejednoznačný nález - potřeba dalšího vyšetření"
    },
    {
      "code" : "2",
      "display" : "negativní"
    },
    {
      "code" : "3",
      "display" : "benigní"
    },
    {
      "code" : "4",
      "display" : "pravděpodobně benigní"
    },
    {
      "code" : "6",
      "display" : "pravděpodobně maligní nález (původně označováno jako maligní)"
    },
    {
      "code" : "7",
      "display" : "bez známek recidivy"
    },
    {
      "code" : "8",
      "display" : "suspektní recidiva"
    },
    {
      "code" : "9",
      "display" : "recidiva"
    },
    {
      "code" : "10",
      "display" : "známá malignita (BIRADS-6)"
    },
    {
      "code" : "51",
      "display" : "pravděpodobnost malignity je nízká (BIRADS-4a)"
    },
    {
      "code" : "52",
      "display" : "pravděpodobnost malignity je střední (BIRADS-4b)"
    },
    {
      "code" : "53",
      "display" : "pravděpodobnost malignity je vysoká (BIRADS-4c)"
    }
  ]
}

```
