# Lung Cancer Result Code System - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Lung Cancer Result Code System**

## CodeSystem: Lung Cancer Result Code System 

| | |
| :--- | :--- |
| *Official URL*:https://ncez.mzcr.cz/terminology/CodeSystem/cz-result-lung-cancer-cs | *Version*:0.0.1 |
| Active as of 2025-12-04 | *Computable Name*:ResultLungCancerCS |

 
Lung cancer result code system 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ResultLungCancerVs](ValueSet-cz-result-lung-cancer-vs.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "cz-result-lung-cancer-cs",
  "language" : "cs",
  "url" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-result-lung-cancer-cs",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986"
    }
  ],
  "version" : "0.0.1",
  "name" : "ResultLungCancerCS",
  "title" : "Lung Cancer Result Code System",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-04",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Lung cancer result code system",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 3,
  "concept" : [
    {
      "code" : "negativni",
      "display" : "negativní"
    },
    {
      "code" : "neurcity",
      "display" : "neurčitý"
    },
    {
      "code" : "pozitivni",
      "display" : "pozitivní"
    }
  ]
}

```
