# Lung Cancer interpretation Code System - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Lung Cancer interpretation Code System**

## CodeSystem: Lung Cancer interpretation Code System 

| | |
| :--- | :--- |
| *Official URL*:https://ncez.mzcr.cz/terminology/CodeSystem/cz-lung-cancer-interpretation-cs | *Version*:0.0.1 |
| Active as of 2025-12-09 | *Computable Name*:LungCancerInterpretationCS |

 
Lung Cancer interpretation code system 

 This Code system is referenced in the content logical definition of the following value sets: 

* [LungCancerInterpretationVS](ValueSet-cz-lung-cancer-interpretation-vs.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "cz-lung-cancer-interpretation-cs",
  "language" : "cs",
  "url" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-lung-cancer-interpretation-cs",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986"
    }
  ],
  "version" : "0.0.1",
  "name" : "LungCancerInterpretationCS",
  "title" : "Lung Cancer interpretation Code System",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-09",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Lung Cancer interpretation code system",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 6,
  "concept" : [
    {
      "code" : "poch",
      "display" : "Pacient doporučen do POCH/KOC"
    },
    {
      "code" : "ldctza2y",
      "display" : "Kontrolní LDCT za 2 roky"
    },
    {
      "code" : "ldctza1y",
      "display" : "Kontrolní LDCT za 1 rok"
    },
    {
      "code" : "ldctza3m",
      "display" : "Kontrolní LDCT za 3 měsíce"
    },
    {
      "code" : "ldctza6w",
      "display" : "Kontrolní LDCT za 6-8 týdnů"
    },
    {
      "code" : "others",
      "display" : "Jiný"
    }
  ]
}

```
