# CZ Document Section SZZ Code System - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ Document Section SZZ Code System**

## CodeSystem: CZ Document Section SZZ Code System 

| | |
| :--- | :--- |
| *Official URL*:https://ncez.mzcr.cz/terminology/CodeSystem/cz-document-section-szz-cs | *Version*:0.0.1 |
| Active as of 2025-12-04 | *Computable Name*:DocumentSectionCzSzzCs |

 
This Code System defines codes for sections used in the Shared Health Record (SZZ) in Czechia. 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "cz-document-section-szz-cs",
  "language" : "cs",
  "url" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-document-section-szz-cs",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986"
    }
  ],
  "version" : "0.0.1",
  "name" : "DocumentSectionCzSzzCs",
  "title" : "CZ Document Section SZZ Code System",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-04",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This Code System defines codes for sections used in the Shared Health Record (SZZ) in Czechia.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 10,
  "concept" : [
    {
      "code" : "10001",
      "display" : "Emergency health record"
    },
    {
      "code" : "10002",
      "display" : "Preventive and screening health record"
    },
    {
      "code" : "10003",
      "display" : "General practitioner record"
    },
    {
      "code" : "10004",
      "display" : "Gynecology record"
    },
    {
      "code" : "10005",
      "display" : "Biochemistry laboratory record"
    },
    {
      "code" : "10006",
      "display" : "Urology record"
    },
    {
      "code" : "10007",
      "display" : "Pulmonology record"
    },
    {
      "code" : "10008",
      "display" : "Gastroenterology record"
    },
    {
      "code" : "10009",
      "display" : "Radiology record"
    },
    {
      "code" : "10010",
      "display" : "Angiology record"
    }
  ]
}

```
