# CZ Colonoscopy Interpretation Code System - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ Colonoscopy Interpretation Code System**

## CodeSystem: CZ Colonoscopy Interpretation Code System 

| | |
| :--- | :--- |
| *Official URL*:https://ncez.mzcr.cz/terminology/CodeSystem/cz-colonoscopy-interpretation | *Version*:0.0.1 |
| Active as of 2025-12-09 | *Computable Name*:CZ_ColonoscopyInterpretation |

 
This code system defines the codes for interpreting colonoscopy findings in the context of the Shared Health Record (SZZ CZ). 

 This Code system is referenced in the content logical definition of the following value sets: 

* [CZ_ColonoscopyInterpretationVS](ValueSet-cz-colonoscopy-interpretation-vs.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "cz-colonoscopy-interpretation",
  "language" : "cs",
  "url" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-colonoscopy-interpretation",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986"
    }
  ],
  "version" : "0.0.1",
  "name" : "CZ_ColonoscopyInterpretation",
  "title" : "CZ Colonoscopy Interpretation Code System",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-09",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This code system defines the codes for interpreting colonoscopy findings in the context of the Shared Health Record (SZZ CZ).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 7,
  "concept" : [
    {
      "code" : "negativni",
      "display" : "negativní - návrat do screeningu"
    },
    {
      "code" : "kolonoskopie6mes",
      "display" : "dispenzární koloskopie za 6 měsíců"
    },
    {
      "code" : "kolonoskopie1rok",
      "display" : "dispenzární koloskopie za 1 rok"
    },
    {
      "code" : "kolonoskopie3roky",
      "display" : "dispenzární koloskopie za 3 roky"
    },
    {
      "code" : "kolonoskopie5let",
      "display" : "dispenzární koloskopie za 5 let"
    },
    {
      "code" : "kolonoskopie10let",
      "display" : "dispenzární koloskopie 10 let"
    },
    {
      "code" : "kolonoskopiejine",
      "display" : "jiné"
    }
  ]
}

```
