# Cervical Cancer Screening HPV Result Code System - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Cervical Cancer Screening HPV Result Code System**

## CodeSystem: Cervical Cancer Screening HPV Result Code System 

| | |
| :--- | :--- |
| *Official URL*:https://ncez.mzcr.cz/terminology/CodeSystem/cz-cervical-cancer-hpv-result-cs | *Version*:0.0.1 |
| Active as of 2025-12-09 | *Computable Name*:CervicalCancerHPVResultCS |

 
Cervical cancer screening HPV result code system 

 This Code system is referenced in the content logical definition of the following value sets: 

* [CervicalCancerHPVResultVS](ValueSet-cz-cervical-cancer-hpv-result-vs.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "cz-cervical-cancer-hpv-result-cs",
  "language" : "cs",
  "url" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-cervical-cancer-hpv-result-cs",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986"
    }
  ],
  "version" : "0.0.1",
  "name" : "CervicalCancerHPVResultCS",
  "title" : "Cervical Cancer Screening HPV Result Code System",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-09",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Cervical cancer screening HPV result code system",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 2,
  "concept" : [
    {
      "code" : "negativni",
      "display" : "Negativní nález"
    },
    {
      "code" : "pozitivni",
      "display" : "Pozitivní nález"
    }
  ]
}

```
