# Table of Contents - HL7 Czech Laboratory Order IG v0.0.1

* **Table of Contents**

HL7 Czech Laboratory Order IG, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.1 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/lab-order/](https://github.com/HL7-cz/lab-order/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/lab-order/history.html)

## Table of Contents

| |
| :--- |
| [0 Table of Contents](toc.md) |
| [1 Home](index.md) |
| [2 Domovská stránka](index-cs.md) |
| [3 Scope and content](scope-and-content-en.md) |
| [4 Oblasti a obsah](scope-and-content-cs.md) |
| [5 Background](background-en.md) |
| [6 Background](background-cs.md) |
| [7 Authors](authors-en.md) |
| [8 Autoři](authors-cs.md) |
| [9 Copyright](copyright-en.md) |
| [10 Autorská práva](copyright-cs.md) |
| [11 Dependencies](dependencies-en.md) |
| [12 Závislosti](dependencies-cs.md) |
| [13 Examples](examples-en.md) |
| [14 Příklady](examples-cs.md) |
| [15 Logical models](logical-models-en.md) |
| [16 Datová sada - logické modely](logical-models-cs.md) |
| [17 Model maps](model-map-en.md) |
| [18 Mapování logického modelu](model-map-cs.md) |
| [19 Obligations](obligations-en.md) |
| [20 Obligations](obligations-cs.md) |
| [21 Terminology considerations](terminology-considerations-en.md) |
| [22 Terminologické aspekty](terminology-considerations-cs.md) |
| [23 Use cases](use-cases-en.md) |
| [24 Příklady užití](use-cases-cs.md) |
| [25 Workflow](workflow-en.md) |
| [26 Workflow](workflow-cs.md) |
| [27 Download](downloads-en.md) |
| [28 Download](downloads-cs.md) |
| [29 Artifacts Summary](artifacts.md) |
| [29.1 A - Laboratorní žádanka](StructureDefinition-LogLabOrderCz.md) |
| [29.2 A.1 - Hlavička dokumentu](StructureDefinition-LogLabOrderHeaderCz.md) |
| [29.3 A.1.1 - Identifikace a A.1.2 - Kontaktní informace Pacienta/subjektu](StructureDefinition-LogSubjectCz.md) |
| [29.4 A.1.3 - Zdravotní pojištění](StructureDefinition-LogPayerCz.md) |
| [29.5 A.1.4 - Úhrada](StructureDefinition-LogCoverageOrderCz.md) |
| [29.6 A.1.5 - Objednatel](StructureDefinition-LogAuthorCz.md) |
| [29.7 A.1.6 - Zpracovatel](StructureDefinition-LogRequestedPerformerCz.md) |
| [29.8 A.1.7 - Příjemce nálezu](StructureDefinition-LogAdditionalRecipientCz.md) |
| [29.9 A.1.8 - Metadata dokumentu](StructureDefinition-LogDocumentMetadataCz.md) |
| [29.10 A.1.9 - Elektronické podpisy](StructureDefinition-LogDigitalSignatureCz.md) |
| [29.11 A.2 Tělo dokumentu](StructureDefinition-LogLabOrderBodyCz.md) |
| [29.12 A.2.1 - Informace o objednávce and A.2.2 - Odůvodnění vyšetření (důvod objednávky)](StructureDefinition-LogLabOrderInformationCz.md) |
| [29.13 A.2.3 - Klinická událost (encounter)](StructureDefinition-LogClinicalEventCz.md) |
| [29.14 A.2.4 - Úhrada](StructureDefinition-LogCoverageBodyCz.md) |
| [29.15 A.2.5 - Termín návštěvy](StructureDefinition-LogLabAppointmentCz.md) |
| [29.16 A.2.6 - Informace o vzorku](StructureDefinition-LogSpecimenInformationCz.md) |
| [29.17 A.2.7 - Klinické informace (anamnéza)](StructureDefinition-LogClinicalInformationCz.md) |
| [29.18 A.2.8 - Datové elementy objednávky vyšetření](StructureDefinition-LogLabOrderDataElementsCz.md) |
| [29.19 A.3 - Vizuální podoba dokumentu](StructureDefinition-LogPresentedFormCz.md) |
| [29.20 A.4 - Přílohy](StructureDefinition-LogAttachmentsCz.md) |
| [29.21 A - Laboratory Order](StructureDefinition-LabOrder.md) |
| [29.22 A.1 Laboratory Order header data elements](StructureDefinition-LabOrderHeader.md) |
| [29.23 A.1.1 - Identification and A.1.2 - related contact information of the Patient/subject](StructureDefinition-SubjectCz.md) |
| [29.24 A.1.3 - Health insurance and payment information](StructureDefinition-PayerCz.md) |
| [29.25 A.1.4 - Information about coverage](StructureDefinition-CoverageOrderCz.md) |
| [29.26 A.1.5 - Author](StructureDefinition-AuthorCz.md) |
| [29.27 A.1.6 - Requested Performer (processing person)](StructureDefinition-RequestedPerformerCz.md) |
| [29.28 A.1.7 - Additional Recipient](StructureDefinition-AdditionalRecipientCz.md) |
| [29.29 A.1.8 - Document metadata](StructureDefinition-DocumentMetadataCz.md) |
| [29.30 A.1.9 - Digital signature](StructureDefinition-DigitalSignatureCz.md) |
| [29.31 A.2 Laboratory Order body data elements](StructureDefinition-LabOrderBody.md) |
| [29.32 A.2.1 - Order information and A.2.2 - Order reason](StructureDefinition-LabOrderInformationCz.md) |
| [29.33 A.2.3 - Clinical event (Encounter)](StructureDefinition-ClinicalEventCz.md) |
| [29.34 A.2.4 - Information about additional coverage](StructureDefinition-CoverageBodyCz.md) |
| [29.35 A.2.5 - Appointment](StructureDefinition-LabAppointmentCz.md) |
| [29.36 A.2.6 - Specimen Information](StructureDefinition-SpecimenInformationCz.md) |
| [29.37 A.2.7 - Clinical information (anamnesis)](StructureDefinition-ClinicalInformationCz.md) |
| [29.38 A.2.8 - Laboratory order data elements](StructureDefinition-LabOrderDataElementsCz.md) |
| [29.39 A.3 - Presented form](StructureDefinition-PresentedFormCz.md) |
| [29.40 A.4 - Attachments](StructureDefinition-AttachmentsCz.md) |
| [29.41 Appointment (CZ)](StructureDefinition-cz-appointment.md) |
| [29.42 Attachment Laboratory Order (CZ)](StructureDefinition-cz-attachment.md) |
| [29.43 Bundle: Laboratory Order (CZ)](StructureDefinition-BundleLabOrderCz.md) |
| [29.44 Clinical question: Laboratory Order (CZ)](StructureDefinition-cz-clinicalQuestion.md) |
| [29.45 Composition: Laboratory Order (CZ)](StructureDefinition-cz-CompositionLabOrder.md) |
| [29.46 Condition: Clinical question (CZ)](StructureDefinition-cz-conditionClinicalQuestion.md) |
| [29.47 Condition: Lab Order (CZ)](StructureDefinition-cz-conditionLab.md) |
| [29.48 Encounter: Lab Order (CZ)](StructureDefinition-cz-encounter.md) |
| [29.49 Observation: Laboratory Order (CZ)](StructureDefinition-cz-observation.md) |
| [29.50 ServiceRequest: Laboratory Order (CZ)](StructureDefinition-cz-serviceRequest.md) |
| [29.51 Specimen: Laboratory Order (CZ)](StructureDefinition-cz-specimen.md) |
| [29.52 Požadavek na akreditaci](StructureDefinition-accreditation-cz.md) |
| [29.53 CZ Diagnosis Condition](ValueSet-cz-diagnosis-condition-vs.md) |
| [29.54 Národní číselník laboratorních položek](ValueSet-labpol.md) |
| [29.55 Valueset of types Clinical event (CZ)](ValueSet-cz-typeClinicalEvent-vs.md) |
| [29.56 Codesystem of Clinical Event Type](CodeSystem-cz-typeClinicalEvent-cs.md) |
| [29.57 CZ Attachment Model to this guide Map](ConceptMap-AttachmentLabOrder2FHIR-cz.md) |
| [29.58 CZ Body Model to this guide Map](ConceptMap-LabOrderBody2FHIR-cz.md) |
| [29.59 CZ Header Model to this guide Map](ConceptMap-LabOrderHeader2FHIRcz-cz.md) |
| [29.60 CZ Lab Order Bundle Example](Bundle-CZ-LabOrder-Bundle-Example.md) |
| [29.61 CZ Lab Order Specimen Example](Specimen-CZ-Lab-Specimen-Example.md) |
| [29.62 Example Appointment – Blood Sample Collection](Appointment-AppointmentExample.md) |
| [29.63 Example Encounter – Laboratory Visit](Encounter-EncounterExample.md) |
| [29.64 Example Laboratory Order](ServiceRequest-CZ-Lab-ServiceRequest-Example.md) |
| [29.65 Example Location – Collection Room](Location-LocationExample.md) |
| [29.66 Nemocnice Žlábek Dolní](Organization-bc2b8a3e-999a-4f10-91ce-1dc12fa0e123.md) |
| [29.67 Organization - Healthcare insurance company](Organization-CZ-Lab-Payor-Example.md) |
| [29.68 Organization: Registering healthcare provider example](Organization-RegisteringProviderExample.md) |
| [29.69 practitionerRoleSejdlova](PractitionerRole-aabbccdd-2222-3333-dddd-112233445566.md) |
| [29.70 practitionerRoleVycichlo](PractitionerRole-99988877-aaaa-4000-bbbb-cceeddccbbaa.md) |
| [29.71 practitionerSejdlova](Practitioner-fab321ab-7777-4444-cccc-abcdefabcdef.md) |
| [29.72 practitionerVycichlo](Practitioner-d12345af-8888-4001-bcde-1234567890ab.md) |
| [29.73 Příklad pojištění zdravotní pojišťovnou](Coverage-CZ-Lab-Coverage-Example.md) |
| [29.74 Zyrgana](Patient-Zyrgana.md) |

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.lab-order#0.0.1 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-08 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

