# Terminology considerations - HL7 Czech Laboratory Order IG v0.0.1

* [**Table of Contents**](toc.md)
* **Terminology considerations**

HL7 Czech Laboratory Order IG, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.1 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/lab-order/](https://github.com/HL7-cz/lab-order/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/lab-order/history.html)

## Terminology considerations

* [NČLP](#nčlp)
* [MKN-10 / Orphacode](#mkn-10--orphacode)
* [ATC/DLP](#atcdlp)
* [Snomed-CT](#snomed-ct)
* [FHIR](#fhir)

The following is a list of the codesystems and valueset used:

### NČLP

| | | |
| :--- | :--- | :--- |
| A.2.7.9.2 | Additional data - code |   |
| A.2.8.1.1 | Examination code | NCLPPOL |
| A.2.8.1.2 | Name of examination | NCLPPOL |
| A.2.8.1.3 | Examination procedure | NCLPPROC |

### MKN-10 / Orphacode

| | | |
| :--- | :--- | :--- |
| A.2.7.3 | Other Relevant Clinical Information -code |   |

### ATC/DLP

| | | |
| :--- | :--- | :--- |
| A.2.7.4 | Medication |   |

### Snomed-CT

| | | |
| :--- | :--- | :--- |
| A.2.2.2 | Clinical question by code |   |
| A.2.2.4 | Reason for ordering by code | 243796009 |
| A.2.6.6 | Specimen type |   |
| A.2.6.7 | Anatomic location |   |
| A.2.6.8 | Morphology |   |
| A.2.6.10 | Collection procedure |   |
| A.2.6.14.1 | Type of container |   |

### FHIR

| | | |
| :--- | :--- | :--- |
| A.1.1.5 | Nationality | https://terminology.hl7.org/4.0.0/ValueSet-v3-Country2.html |
| A.1.1.6 | Gender | https://terminology.hl7.org/4.0.0/ValueSet-v3-AdministrativeGender.html |
| A.1.2.1 | Address | https://terminology.hl7.org/4.0.0/ValueSet-v3-Country2.html |
| A.1.4.1 | Method of coverage | http://hl7.org/fhir/ValueSet/coverage-kind |
| A.1.8.2 | Document category | http://hl7.org/fhir/ValueSet/referenced-item-category |
| A.1.8.3 | Document status | https://hl7.org/fhir/valueset-request-status.html |
| A.1.8.7 | Confidentiality | https://terminology.hl7.org/ValueSet-v3-Confidentiality.html |
| A.2.1.4 | Urgency of the order | https://hl7.org/fhir/valueset-request-priority.html |
| A.2.4.1 | Method of coverage | http://hl7.org/fhir/ValueSet/coverage-kind |

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.lab-order#0.0.1 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-08 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

