# Terminologické aspekty - HL7 Czech Laboratory Order IG v0.0.1

* [**Table of Contents**](toc.md)
* **Terminologické aspekty**

HL7 Czech Laboratory Order IG, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.1 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/lab-order/](https://github.com/HL7-cz/lab-order/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/lab-order/history.html)

## Terminologické aspekty

* [NČLP](#nčlp)
* [MKN-10 / Orphacode](#mkn-10--orphacode)
* [ATC/DLP](#atcdlp)
* [Snomed-CT](#snomed-ct)
* [FHIR](#fhir)

Následuje seznam použitých kódovacích systémů a číselníků:

### NČLP

| | | |
| :--- | :--- | :--- |
| A.2.7.9.2 | Další formalizované údaje - kód |   |
| A.2.8.1.1 | Kód vyšetření | NCLPPOL |
| A.2.8.1.2 | Název vyšetření | NCLPPOL |
| A.2.8.1.3 | Metoda měření | NCLPPROC |

### MKN-10 / Orphacode

| | | |
| :--- | :--- | :--- |
| A.2.7.3 | Popis problému / diagnózy / stavu |   |

### ATC/DLP

| | | |
| :--- | :--- | :--- |
| A.2.7.4 | Medikace |   |

### Snomed-CT

| | | |
| :--- | :--- | :--- |
| A.2.2.2 | Klinická otázka kódem |   |
| A.2.2.4 | Důvod objednávky kódem | 243796009 |
| A.2.6.6 | Typ vzorku |   |
| A.2.6.7 | Anatomické umístění |   |
| A.2.6.8 | Morfologie |   |
| A.2.6.10 | Procedura / metoda sběru |   |
| A.2.6.14.1 | Kontejner – typ |   |

### FHIR

| | | |
| :--- | :--- | :--- |
| A.1.1.6 | Státní občanství | https://terminology.hl7.org/4.0.0/ValueSet-v3-Country2.html |
| A.1.2.1 | Úřední pohlaví | https://terminology.hl7.org/4.0.0/ValueSet-v3-AdministrativeGender.html |
| A.1.4.1 | Adresa | https://terminology.hl7.org/4.0.0/ValueSet-v3-Country2.html |
| A.1.4.1 | Způsob úhrady | http://hl7.org/fhir/ValueSet/coverage-kind |
| A.1.8.2 | Document category | http://hl7.org/fhir/ValueSet/referenced-item-category |
| A.1.8.3 | Stav žádanky | https://hl7.org/fhir/valueset-request-status.html |
| A.1.8.7 | Důvěrnost žádanky | https://terminology.hl7.org/ValueSet-v3-Confidentiality.html |
| A.2.1.4 | Urgentnost objednávky | https://hl7.org/fhir/valueset-request-priority.html |
| A.2.4.1 | Způsob úhrady | http://hl7.org/fhir/ValueSet/coverage-kind |

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.lab-order#0.0.1 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-08 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

