# Logical models - HL7 Czech Laboratory Order IG v0.0.1

* [**Table of Contents**](toc.md)
* **Logical models**

HL7 Czech Laboratory Order IG, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.1 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/lab-order/](https://github.com/HL7-cz/lab-order/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/lab-order/history.html)

## Logical models

This page lists HL7 FHIR logical models used to represent the laboratory order.

| | | |
| :--- | :--- | :--- |
| Name | Title | Description |
| [LogEnSubjectLabOrderCz](StructureDefinition-SubjectCz.md) | A.1.1 - Identification and A.1.2 - related contact information of the Patient/subject | Laboratory Order - Laboratory Order subject data element - A.1.1 and A.1.2 |
| [LogEnPayerOrderCz](StructureDefinition-PayerCz.md) | A.1.3 - Health insurance and payment information | Health insurance and payment information - Health insurance information is not always required, however, in some jurisdictions, the insurance number is also used as the patient identifier. It is necessary not just for identification but also forms access to funding for care. |
| [LogEnCoverageOrderCz](StructureDefinition-CoverageOrderCz.md) | A.1.4 - Information about coverage | Coverage information - Information about method of coverage, payer identification data and additional information |
| [LogEnAuthorOrderCz](StructureDefinition-AuthorCz.md) | A.1.5 - Author | Author (by whom the Lab order was/were authored). Multiple authors could be provided. |
| [LogEnRequestedPerformerOrderCz](StructureDefinition-RequestedPerformerCz.md) | A.1.6 - Requested Performer (processing person) | Person who is requested to process document. |
| [LogEnAdditionalRecipient](StructureDefinition-AdditionalRecipientCz.md) | A.1.7 - Additional Recipient | Additional Recipient (Additional recipients of the finding in addition to the author) |
| [LogEnDocumentMetadataOrderCz](StructureDefinition-DocumentMetadataCz.md) | A.1.8 - Document metadata | Document metadata |
| [LogEnDigitalSignatureCz](StructureDefinition-DigitalSignatureCz.md) | A.1.9 - Digital signature | Digital signature - Electronic signature or seal of a document according to Act 327/2011 §54a |
| [LogEnImageOrderInformationCz](StructureDefinition-LabOrderInformationCz.md) | A.2.1 - Order information and A.2.2 - Order reason | Information about order and order reason |
| [LogEnClinicalEventCz](StructureDefinition-ClinicalEventCz.md) | A.2.3 - Clinical event (Encounter) | Clinical event (Encounter) - Information about the clinical event to which the order relates |
| [LogEnCoverageBodyCz](StructureDefinition-CoverageBodyCz.md) | A.2.4 - Information about additional coverage | Additional coverage information - Information about method of coverage, payer identification data and additional information |
| [LogEnImageAppointmentCz](StructureDefinition-LabAppointmentCz.md) | A.2.5 - Appointment | Appointment - Links to planned care order related to this request form |
| [LogEnSpecimenInformationCz](StructureDefinition-SpecimenInformationCz.md) | A.2.6 - Specimen Information | Information about specimen |
| [LogEnPresentedFormCz](StructureDefinition-PresentedFormCz.md) | A.3 - Presented form | Presented form - Entire order as issued. Various formats could be provided, pdf format is recommended. |
| [LogEnAttachmentsCz](StructureDefinition-AttachmentsCz.md) | A.4 - Attachments | Additional attachments. |

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.lab-order#0.0.1 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-08 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

