# Datová sada - logické modely - HL7 Czech Laboratory Order IG v0.0.1

* [**Table of Contents**](toc.md)
* **Datová sada - logické modely**

HL7 Czech Laboratory Order IG, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.1 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/lab-order/](https://github.com/HL7-cz/lab-order/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/lab-order/history.html)

## Datová sada - logické modely

Tato stránka uvádí logické modely HL7 FHIR používané k reprezentaci Laboratorní žádanky.

| | | |
| :--- | :--- | :--- |
| Name | Title | Description |
| [LogCzLabOrderCz](StructureDefinition-LogLabOrderCz.md) | A - Laboratorní žádanka | Laboratorní žádanka. |
| [LogCzLabOrderHeaderCz](StructureDefinition-LogLabOrderHeaderCz.md) | A.1 - Hlavička dokumentu | Záhlaví dokumentu s administrativními údaji |
| [LogCzSubjectLabOrderCz](StructureDefinition-LogSubjectCz.md) | A.1.1 - Identifikace a A.1.2 - Kontaktní informace Pacienta/subjektu | Identifikace pacienta a kontaktní informace pacienta |
| [LogCzPayerOrderCz](StructureDefinition-LogPayerCz.md) | A.1.3 - Zdravotní pojištění | Informace o zdravotním pojištění. |
| [LogCzCoverageOrderCz](StructureDefinition-LogCoverageOrderCz.md) | A.1.4 - Úhrada | Informace o způsobu úhrady objednávky vyšetření |
| [LogCzAuthorOrderCz](StructureDefinition-LogAuthorCz.md) | A.1.5 - Objednatel | Objednatel (Objednatel provedení zdravotní služby). |
| [LogCzRequestedPerformerOrderCz](StructureDefinition-LogRequestedPerformerCz.md) | A.1.6 - Zpracovatel | Předpokládaný zpracovatel žádanky (u neadresné žádanky nebude zpracovatel uveden). |
| [LogCzAdditionalRecipient](StructureDefinition-LogAdditionalRecipientCz.md) | A.1.7 - Příjemce nálezu | Příjemce nálezu (Dodateční příjemci nálezu kromě objednatele) |
| [LogCzDocumentMetadataOrderCz](StructureDefinition-LogDocumentMetadataCz.md) | A.1.8 - Metadata dokumentu | Metadata dokumentu |
| [LogCzDigitalSignatureCz](StructureDefinition-LogDigitalSignatureCz.md) | A.1.9 - Elektronické podpisy | Elektronické podpisy - Elektronické podpisy nebo pečetě dle zákona 327/2011 §54a |
| [LogCzLabOrderBodyCz](StructureDefinition-LogLabOrderBodyCz.md) | A.2 Tělo dokumentu | Tělo dokumentu |
| [LogCzLabOrderInformationCz](StructureDefinition-LogLabOrderInformationCz.md) | A.2.1 - Informace o objednávce and A.2.2 - Odůvodnění vyšetření (důvod objednávky) | Informace o objednávce a Odůvodnění vyšetření (důvod objednávky) |
| [LogCzClinicalEventCz](StructureDefinition-LogClinicalEventCz.md) | A.2.3 - Klinická událost (encounter) | Informace o klinické události, ke které se objednávka vztahuje (odkaz na návštěvu) |
| [LogCzCoverageBodyCz](StructureDefinition-LogCoverageBodyCz.md) | A.2.4 - Úhrada | Informace o způsobu úhrady objednávky vyšetření |
| [LogCzImageAppointmentCz](StructureDefinition-LogLabAppointmentCz.md) | A.2.5 - Termín návštěvy | Informace o objednaném termínu vyšetření (pokud byl termín rezervován) |
| [LogCzSpecimenInformationCz](StructureDefinition-LogSpecimenInformationCz.md) | A.2.6 - Informace o vzorku | Pro specifická laboratorní vyšetření vzorku |
| [LogCzLabOrderClinicalInformationCz](StructureDefinition-LogClinicalInformationCz.md) | A.2.7 - Klinické informace (anamnéza) | Informace a údaje sdělované laboratoři, mající vliv na provedení objednávky či interpretaci výsledků |
| [LogCzLabOrderDataElementsCz](StructureDefinition-LogLabOrderDataElementsCz.md) | A.2.8 - Datové elementy objednávky vyšetření | Datové elementy objednávky vyšetření |
| [LogCzPresentedFormCz](StructureDefinition-LogPresentedFormCz.md) | A.3 - Vizuální podoba dokumentu | Žádanka laboratorní vyšetření čitelná lidským okem, je požadován PDF formát. |
| [LogCzAttachmentsCz](StructureDefinition-LogAttachmentsCz.md) | A.4 - Přílohy | Ostatní přílohy. |

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.lab-order#0.0.1 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-08 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

