# Copyright - HL7 Czech Laboratory Order IG v0.0.1

* [**Table of Contents**](toc.md)
* **Copyright**

HL7 Czech Laboratory Order IG, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.1 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/lab-order/](https://github.com/HL7-cz/lab-order/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/lab-order/history.html)

## Copyright

### IP statements

This publication includes IP covered under the following statements.

* Copyright HL7. Licensed under creative commons public domain

* [specimenType](http://terminology.hl7.org/5.0.0/CodeSystem-v2-0487.html): [Bundle/CZ-LabOrder-Bundle-Example](Bundle-CZ-LabOrder-Bundle-Example.md) and [Specimen/CZ-Lab-Specimen-Example](Specimen-CZ-Lab-Specimen-Example.md)


* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.5.0/CodeSystem-ISO3166Part1.html): [AccreditationCz](StructureDefinition-accreditation-cz.md), [AttachmentLabOrder2FHIRcz](ConceptMap-AttachmentLabOrder2FHIR-cz.md)...Show 61 more,[Bundle/CZ-LabOrder-Bundle-Example](Bundle-CZ-LabOrder-Bundle-Example.md),[BundleLabOrderCz](StructureDefinition-BundleLabOrderCz.md),[CZ_Appointment](StructureDefinition-cz-appointment.md),[CZ_Attachment](StructureDefinition-cz-attachment.md),[CZ_ClinicalQuestion](StructureDefinition-cz-clinicalQuestion.md),[CZ_CompositionLabOrder](StructureDefinition-cz-CompositionLabOrder.md),[CZ_ConditionClinicalQuestion](StructureDefinition-cz-conditionClinicalQuestion.md),[CZ_ConditionLab](StructureDefinition-cz-conditionLab.md),[CZ_DiagnosisConditionVs](ValueSet-cz-diagnosis-condition-vs.md),[CZ_Encounter](StructureDefinition-cz-encounter.md),[CZ_NclpLabpolVS](ValueSet-labpol.md),[CZ_ObservationLab](StructureDefinition-cz-observation.md),[CZ_ServiceRequest](StructureDefinition-cz-serviceRequest.md),[CZ_SpecimenLab](StructureDefinition-cz-specimen.md),[CZ_TypeClinicalEventCs](CodeSystem-cz-typeClinicalEvent-cs.md),[CZ_TypeClinicalEventVs](ValueSet-cz-typeClinicalEvent-vs.md),[HL7CzLabOrderImplementationGuide](index.md),[LabOrderBody2FHIRcz](ConceptMap-LabOrderBody2FHIR-cz.md),[LabOrderBodyCz](StructureDefinition-LabOrderBody.md),[LabOrderClinicalInformationCz](StructureDefinition-ClinicalInformationCz.md),[LabOrderCz](StructureDefinition-LabOrder.md),[LabOrderDataElementsCz](StructureDefinition-LabOrderDataElementsCz.md),[LabOrderHeader2FHIRcz](ConceptMap-LabOrderHeader2FHIRcz-cz.md),[LabOrderHeaderCz](StructureDefinition-LabOrderHeader.md),[LogCzAdditionalRecipient](StructureDefinition-LogAdditionalRecipientCz.md),[LogCzAttachmentsCz](StructureDefinition-LogAttachmentsCz.md),[LogCzAuthorOrderCz](StructureDefinition-LogAuthorCz.md),[LogCzClinicalEventCz](StructureDefinition-LogClinicalEventCz.md),[LogCzCoverageBodyCz](StructureDefinition-LogCoverageBodyCz.md),[LogCzCoverageOrderCz](StructureDefinition-LogCoverageOrderCz.md),[LogCzDigitalSignatureCz](StructureDefinition-LogDigitalSignatureCz.md),[LogCzDocumentMetadataOrderCz](StructureDefinition-LogDocumentMetadataCz.md),[LogCzImageAppointmentCz](StructureDefinition-LogLabAppointmentCz.md),[LogCzLabOrderBodyCz](StructureDefinition-LogLabOrderBodyCz.md),[LogCzLabOrderClinicalInformationCz](StructureDefinition-LogClinicalInformationCz.md),[LogCzLabOrderCz](StructureDefinition-LogLabOrderCz.md),[LogCzLabOrderDataElementsCz](StructureDefinition-LogLabOrderDataElementsCz.md),[LogCzLabOrderHeaderCz](StructureDefinition-LogLabOrderHeaderCz.md),[LogCzLabOrderInformationCz](StructureDefinition-LogLabOrderInformationCz.md),[LogCzPayerOrderCz](StructureDefinition-LogPayerCz.md),[LogCzPresentedFormCz](StructureDefinition-LogPresentedFormCz.md),[LogCzRequestedPerformerOrderCz](StructureDefinition-LogRequestedPerformerCz.md),[LogCzSpecimenInformationCz](StructureDefinition-LogSpecimenInformationCz.md),[LogCzSubjectLabOrderCz](StructureDefinition-LogSubjectCz.md),[LogEnAdditionalRecipient](StructureDefinition-AdditionalRecipientCz.md),[LogEnAttachmentsCz](StructureDefinition-AttachmentsCz.md),[LogEnAuthorOrderCz](StructureDefinition-AuthorCz.md),[LogEnClinicalEventCz](StructureDefinition-ClinicalEventCz.md),[LogEnCoverageBodyCz](StructureDefinition-CoverageBodyCz.md),[LogEnCoverageOrderCz](StructureDefinition-CoverageOrderCz.md),[LogEnDigitalSignatureCz](StructureDefinition-DigitalSignatureCz.md),[LogEnDocumentMetadataOrderCz](StructureDefinition-DocumentMetadataCz.md),[LogEnImageAppointmentCz](StructureDefinition-LabAppointmentCz.md),[LogEnImageOrderInformationCz](StructureDefinition-LabOrderInformationCz.md),[LogEnPayerOrderCz](StructureDefinition-PayerCz.md),[LogEnPresentedFormCz](StructureDefinition-PresentedFormCz.md),[LogEnRequestedPerformerOrderCz](StructureDefinition-RequestedPerformerCz.md),[LogEnSpecimenInformationCz](StructureDefinition-SpecimenInformationCz.md),[LogEnSubjectLabOrderCz](StructureDefinition-SubjectCz.md),[Nemocnice Žlábek Dolní](Organization-bc2b8a3e-999a-4f10-91ce-1dc12fa0e123.md)and[Patient/Zyrgana](Patient-Zyrgana.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.5.0/CodeSystem-v3-loinc.html): [Bundle/CZ-LabOrder-Bundle-Example](Bundle-CZ-LabOrder-Bundle-Example.md) and [CZ_CompositionLabOrder](StructureDefinition-cz-CompositionLabOrder.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://hl7.org/fhir/R4/codesystem-snomedct.html): [Bundle/CZ-LabOrder-Bundle-Example](Bundle-CZ-LabOrder-Bundle-Example.md), [CZ_ClinicalQuestion](StructureDefinition-cz-clinicalQuestion.md)...Show 5 more,[CZ_ConditionClinicalQuestion](StructureDefinition-cz-conditionClinicalQuestion.md),[CZ_ConditionLab](StructureDefinition-cz-conditionLab.md),[CZ_ServiceRequest](StructureDefinition-cz-serviceRequest.md),[ServiceRequest/CZ-Lab-ServiceRequest-Example](ServiceRequest-CZ-Lab-ServiceRequest-Example.md)and[Specimen/CZ-Lab-Specimen-Example](Specimen-CZ-Lab-Specimen-Example.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Condition Category Codes](http://terminology.hl7.org/6.5.0/CodeSystem-condition-category.html): [CZ_ClinicalQuestion](StructureDefinition-cz-clinicalQuestion.md) and [CZ_ConditionLab](StructureDefinition-cz-conditionLab.md)
* [identifierType](http://terminology.hl7.org/6.5.0/CodeSystem-v2-0203.html): [Patient/Zyrgana](Patient-Zyrgana.md)
* [ActCode](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActCode.html): [Encounter/EncounterExample](Encounter-EncounterExample.md)


 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.lab-order#0.0.1 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-08 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

