# Artifacts Summary - HL7 Czech Laboratory Order IG v0.0.1

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

HL7 Czech Laboratory Order IG, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.1 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/lab-order/](https://github.com/HL7-cz/lab-order/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/lab-order/history.html)

## Artifacts Summary

Contents:

*  [Czech logical model (Informative)](#1) 
*  [Structures: Logical Models](#2) 
*  [Structures: Resource Profiles](#3) 
*  [Structures: Extension Definitions](#4) 
*  [Terminology: Value Sets](#5) 
*  [Terminology: Code Systems](#6) 
*  [Terminology: Concept Maps](#7) 
*  [Example: Example Instances](#8) 

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Czech logical model (Informative) 

Logical model in czech language. Informative for this version of the guide.

| | |
| :--- | :--- |
| [A - Laboratorní žádanka](StructureDefinition-LogLabOrderCz.md) | Laboratorní žádanka. |
| [A.1 - Hlavička dokumentu](StructureDefinition-LogLabOrderHeaderCz.md) | Záhlaví dokumentu s administrativními údaji |
| [A.1.1 - Identifikace a A.1.2 - Kontaktní informace Pacienta/subjektu](StructureDefinition-LogSubjectCz.md) | Identifikace pacienta a kontaktní informace pacienta |
| [A.1.3 - Zdravotní pojištění](StructureDefinition-LogPayerCz.md) | Informace o zdravotním pojištění. |
| [A.1.4 - Úhrada](StructureDefinition-LogCoverageOrderCz.md) | Informace o způsobu úhrady objednávky vyšetření |
| [A.1.5 - Objednatel](StructureDefinition-LogAuthorCz.md) | Objednatel (Objednatel provedení zdravotní služby). |
| [A.1.6 - Zpracovatel](StructureDefinition-LogRequestedPerformerCz.md) | Předpokládaný zpracovatel žádanky (u neadresné žádanky nebude zpracovatel uveden). |
| [A.1.7 - Příjemce nálezu](StructureDefinition-LogAdditionalRecipientCz.md) | Příjemce nálezu (Dodateční příjemci nálezu kromě objednatele) |
| [A.1.8 - Metadata dokumentu](StructureDefinition-LogDocumentMetadataCz.md) | Metadata dokumentu |
| [A.1.9 - Elektronické podpisy](StructureDefinition-LogDigitalSignatureCz.md) | Elektronické podpisy - Elektronické podpisy nebo pečetě dle zákona 327/2011 §54a |
| [A.2 Tělo dokumentu](StructureDefinition-LogLabOrderBodyCz.md) | Tělo dokumentu |
| [A.2.1 - Informace o objednávce and A.2.2 - Odůvodnění vyšetření (důvod objednávky)](StructureDefinition-LogLabOrderInformationCz.md) | Informace o objednávce a Odůvodnění vyšetření (důvod objednávky) |
| [A.2.3 - Klinická událost (encounter)](StructureDefinition-LogClinicalEventCz.md) | Informace o klinické události, ke které se objednávka vztahuje (odkaz na návštěvu) |
| [A.2.4 - Úhrada](StructureDefinition-LogCoverageBodyCz.md) | Informace o způsobu úhrady objednávky vyšetření |
| [A.2.5 - Termín návštěvy](StructureDefinition-LogLabAppointmentCz.md) | Informace o objednaném termínu vyšetření (pokud byl termín rezervován) |
| [A.2.6 - Informace o vzorku](StructureDefinition-LogSpecimenInformationCz.md) | Pro specifická laboratorní vyšetření vzorku |
| [A.2.7 - Klinické informace (anamnéza)](StructureDefinition-LogClinicalInformationCz.md) | Informace a údaje sdělované laboratoři, mající vliv na provedení objednávky či interpretaci výsledků |
| [A.2.8 - Datové elementy objednávky vyšetření](StructureDefinition-LogLabOrderDataElementsCz.md) | Datové elementy objednávky vyšetření |
| [A.3 - Vizuální podoba dokumentu](StructureDefinition-LogPresentedFormCz.md) | Žádanka laboratorní vyšetření čitelná lidským okem, je požadován PDF formát. |
| [A.4 - Přílohy](StructureDefinition-LogAttachmentsCz.md) | Ostatní přílohy. |

### Structures: Logical Models 

These define data models that represent the domain covered by this implementation guide in more business-friendly terms than the underlying FHIR resources.

| | |
| :--- | :--- |
| [A - Laboratory Order](StructureDefinition-LabOrder.md) | Laboratory Order. |
| [A.1 Laboratory Order header data elements](StructureDefinition-LabOrderHeader.md) | Laboratory Order header data elements |
| [A.1.1 - Identification and A.1.2 - related contact information of the Patient/subject](StructureDefinition-SubjectCz.md) | Laboratory Order - Laboratory Order subject data element - A.1.1 and A.1.2 |
| [A.1.3 - Health insurance and payment information](StructureDefinition-PayerCz.md) | Health insurance and payment information - Health insurance information is not always required, however, in some jurisdictions, the insurance number is also used as the patient identifier. It is necessary not just for identification but also forms access to funding for care. |
| [A.1.4 - Information about coverage](StructureDefinition-CoverageOrderCz.md) | Coverage information - Information about method of coverage, payer identification data and additional information |
| [A.1.5 - Author](StructureDefinition-AuthorCz.md) | Author (by whom the Lab order was/were authored). Multiple authors could be provided. |
| [A.1.6 - Requested Performer (processing person)](StructureDefinition-RequestedPerformerCz.md) | Person who is requested to process document. |
| [A.1.7 - Additional Recipient](StructureDefinition-AdditionalRecipientCz.md) | Additional Recipient (Additional recipients of the finding in addition to the author) |
| [A.1.8 - Document metadata](StructureDefinition-DocumentMetadataCz.md) | Document metadata |
| [A.1.9 - Digital signature](StructureDefinition-DigitalSignatureCz.md) | Digital signature - Electronic signature or seal of a document according to Act 327/2011 §54a |
| [A.2 Laboratory Order body data elements](StructureDefinition-LabOrderBody.md) | Laboratory Order body data elements |
| [A.2.1 - Order information and A.2.2 - Order reason](StructureDefinition-LabOrderInformationCz.md) | Information about order and order reason |
| [A.2.3 - Clinical event (Encounter)](StructureDefinition-ClinicalEventCz.md) | Clinical event (Encounter) - Information about the clinical event to which the order relates |
| [A.2.4 - Information about additional coverage](StructureDefinition-CoverageBodyCz.md) | Additional coverage information - Information about method of coverage, payer identification data and additional information |
| [A.2.5 - Appointment](StructureDefinition-LabAppointmentCz.md) | Appointment - Links to planned care order related to this request form |
| [A.2.6 - Specimen Information](StructureDefinition-SpecimenInformationCz.md) | Information about specimen |
| [A.2.7 - Clinical information (anamnesis)](StructureDefinition-ClinicalInformationCz.md) | Information and data communicated to the laboratory affecting the execution of the order or the interpretation of the results |
| [A.2.8 - Laboratory order data elements](StructureDefinition-LabOrderDataElementsCz.md) | Laboratory order data elements |
| [A.3 - Presented form](StructureDefinition-PresentedFormCz.md) | Presented form - Entire order as issued. Various formats could be provided, pdf format is recommended. |
| [A.4 - Attachments](StructureDefinition-AttachmentsCz.md) | Additional attachments. |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Appointment (CZ)](StructureDefinition-cz-appointment.md) | Czech profile for appointment. |
| [Attachment Laboratory Order (CZ)](StructureDefinition-cz-attachment.md) | Czech profile for attachment. |
| [Bundle: Laboratory Order (CZ)](StructureDefinition-BundleLabOrderCz.md) | Clinical document used to represent a Laboratory Order for the scope of this guide. |
| [Clinical question: Laboratory Order (CZ)](StructureDefinition-cz-clinicalQuestion.md) | Clinical question for Laboratory Order for the scope of the Czech national interoperability project. |
| [Composition: Laboratory Order (CZ)](StructureDefinition-cz-CompositionLabOrder.md) | Clinical document used to represent a Laboratory Order for the scope of this guide. |
| [Condition: Clinical question (CZ)](StructureDefinition-cz-conditionClinicalQuestion.md) | Condition for purpose of clinical question in Lab Order for the scope of the Czech national interoperability project. |
| [Condition: Lab Order (CZ)](StructureDefinition-cz-conditionLab.md) | Condition for Lab Order for the scope of the Czech national interoperability project. |
| [Encounter: Lab Order (CZ)](StructureDefinition-cz-encounter.md) | Czech profile for encounter. |
| [Observation: Laboratory Order (CZ)](StructureDefinition-cz-observation.md) | Observation for Laboratory Order for the scope of the Czech national interoperability project. |
| [ServiceRequest: Laboratory Order (CZ)](StructureDefinition-cz-serviceRequest.md) | ServiceRequest used to represent a Laboratory Order for the scope of the Czech national interoperability project. |
| [Specimen: Laboratory Order (CZ)](StructureDefinition-cz-specimen.md) | Czech profile for a specimen in a laboratory order. In some laboratory order, specimen information is allowed to be minimal as many informations concerning the specimen are implied by the observations done. |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Požadavek na akreditaci](StructureDefinition-accreditation-cz.md) | Vyšetření má být provedeno pouze laboratoří, která má akreditaci pro dané vyšetření. |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [CZ Diagnosis Condition](ValueSet-cz-diagnosis-condition-vs.md) | ValueSet for diagnosis in condition in the Czech Imaging project, using MKN-10 and ORPHA codes. |
| [Národní číselník laboratorních položek](ValueSet-labpol.md) | Sada obsahuje všechny položky kódového systému NČLP, které se používají pro identifikaci laboratorních testů, a to jak na laboratorních žádankách, tak v laboratorních nálezech a jiných typech zdravotnické dokumentace. |
| [Valueset of types Clinical event (CZ)](ValueSet-cz-typeClinicalEvent-vs.md) | Value Set Type clinical event - Typ KU |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Codesystem of Clinical Event Type](CodeSystem-cz-typeClinicalEvent-cs.md) | Codesystem of Clinical Event Type. Code for Clinical Event type (Typ KU). |

### Terminology: Concept Maps 

These define transformations to convert between codes by systems conforming with this implementation guide.

| | |
| :--- | :--- |
| [CZ Attachment Model to this guide Map](ConceptMap-AttachmentLabOrder2FHIR-cz.md) | CZ Lab Order Attachment Model to this guide mapping |
| [CZ Body Model to this guide Map](ConceptMap-LabOrderBody2FHIR-cz.md) | CZ Lab Order Body Model to this guide mapping |
| [CZ Header Model to this guide Map](ConceptMap-LabOrderHeader2FHIRcz-cz.md) | CZ Laboratory Order Header Model to this guide mapping |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [CZ Lab Order Bundle Example](Bundle-CZ-LabOrder-Bundle-Example.md) | Czech Lab Order - example of a bundle |
| [CZ Lab Order Specimen Example](Specimen-CZ-Lab-Specimen-Example.md) | Czech Lab Order - example of a specimen |
| [Example Appointment – Blood Sample Collection](Appointment-AppointmentExample.md) | Appointment for laboratory sample collection |
| [Example Encounter – Laboratory Visit](Encounter-EncounterExample.md) | Encounter related to laboratory order and specimen collection |
| [Example Laboratory Order](ServiceRequest-CZ-Lab-ServiceRequest-Example.md) | Example instance of CZ_ServiceRequest for a blood test |
| [Example Location – Collection Room](Location-LocationExample.md) | Location for lab sample collection |
| [Nemocnice Žlábek Dolní](Organization-bc2b8a3e-999a-4f10-91ce-1dc12fa0e123.md) | Zdravotnické zařízení, které žádá laboratorní vyšetření. |
| [Organization - Healthcare insurance company](Organization-CZ-Lab-Payor-Example.md) | Example of insurance organisation |
| [Organization: Registering healthcare provider example](Organization-RegisteringProviderExample.md) | Fiktivní registrující poskytovatel zdravotní péče |
| [Příklad pojištění zdravotní pojišťovnou](Coverage-CZ-Lab-Coverage-Example.md) | Příklad pojištění |
| [Zyrgana](Patient-Zyrgana.md) | Fiktivní pacientka pro účel příkladu |
| [practitionerRoleSejdlova](PractitionerRole-aabbccdd-2222-3333-dddd-112233445566.md) | Role Mgr. Kvildy Šejdlové (provádějící laborant) |
| [practitionerRoleVycichlo](PractitionerRole-99988877-aaaa-4000-bbbb-cceeddccbbaa.md) | Role MUDr. Erazima Vyčichla (žádající lékař) |
| [practitionerSejdlova](Practitioner-fab321ab-7777-4444-cccc-abcdefabcdef.md) | Virtuální laborantka Mgr. Kvilda Šejdlová |
| [practitionerVycichlo](Practitioner-d12345af-8888-4001-bcde-1234567890ab.md) | Virtuální lékař MUDr. Erazim Vyčichlo |

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.lab-order#0.0.1 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-08 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

