# Národní číselník laboratorních položek - HL7 Czech Laboratory Order IG v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Národní číselník laboratorních položek**

HL7 Czech Laboratory Order IG, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.1 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/lab-order/](https://github.com/HL7-cz/lab-order/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/lab-order/history.html)

*  [Narrative Content](#) 
*  [XML](ValueSet-labpol.xml.md) 
*  [JSON](ValueSet-labpol.json.md) 
*  [TTL](ValueSet-labpol.ttl.md) 

## ValueSet: Národní číselník laboratorních položek 

| | |
| :--- | :--- |
| *Official URL*:https://nclp.ncez.mzcr.cz/ValuSet/nclppol | *Version*:0.0.1 |
| Active as of 2023-01-01 | *Computable Name*:CZ_NclpLabpolVS |

 
Sada obsahuje všechny položky kódového systému NČLP, které se používají pro identifikaci laboratorních testů, a to jak na laboratorních žádankách, tak v laboratorních nálezech a jiných typech zdravotnické dokumentace. 

 **References** 

* [ServiceRequest: Laboratory Order (CZ)](StructureDefinition-cz-serviceRequest.md)

### Logical Definition (CLD)

version: 1; Last updated: 2023-01-01 00:00:00+0100

* Include all codes defined in `https://nclp.ncez.mzcr.cz/CodeSystem/nclppol` version Not Stated (use latest from terminology server)

 

### Expansion

No Expansion for this valueset (Unknown Code System)

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.lab-order#0.0.1 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-08 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

