# Valueset of types Clinical event (CZ) - HL7 Czech Laboratory Order IG v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Valueset of types Clinical event (CZ)**

HL7 Czech Laboratory Order IG, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.1 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/lab-order/](https://github.com/HL7-cz/lab-order/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/lab-order/history.html)

*  [Narrative Content](#) 
*  [XML](ValueSet-cz-typeClinicalEvent-vs.xml.md) 
*  [JSON](ValueSet-cz-typeClinicalEvent-vs.json.md) 
*  [TTL](ValueSet-cz-typeClinicalEvent-vs.ttl.md) 

## ValueSet: Valueset of types Clinical event (CZ) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab-order/ValueSet/cz-typeClinicalEvent-vs | *Version*:0.0.1 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:CZ_TypeClinicalEventVs |

 
Value Set Type clinical event - Typ KU 

 **References** 

* [Composition: Laboratory Order (CZ)](StructureDefinition-cz-CompositionLabOrder.md)

### Logical Definition (CLD)

Language: cs

* Include all codes defined in [`https://hl7.cz/fhir/lab-order/CodeSystem/cz-typeClinicalEvent-cs`](CodeSystem-cz-typeClinicalEvent-cs.md) version 📦0.0.1

 

### Expansion

Expansion performed internally based on [codesystem Codesystem of Clinical Event Type v0.0.1 (CodeSystem)](CodeSystem-cz-typeClinicalEvent-cs.md)

This value set contains 154 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.lab-order#0.0.1 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-08 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

