# CZ Diagnosis Condition - HL7 Czech Laboratory Order IG v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CZ Diagnosis Condition**

HL7 Czech Laboratory Order IG, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.1 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/lab-order/](https://github.com/HL7-cz/lab-order/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/lab-order/history.html)

*  [Narrative Content](#) 
*  [XML](ValueSet-cz-diagnosis-condition-vs.xml.md) 
*  [JSON](ValueSet-cz-diagnosis-condition-vs.json.md) 
*  [TTL](ValueSet-cz-diagnosis-condition-vs.ttl.md) 

## ValueSet: CZ Diagnosis Condition 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab-order/ValueSet/cz-diagnosis-condition-vs | *Version*:0.0.1 |
| Draft as of 2025-10-08 | *Computable Name*:CZ_DiagnosisConditionVs |

 
ValueSet for diagnosis in condition in the Czech Imaging project, using MKN-10 and ORPHA codes. 

 **References** 

* [Condition: Lab Order (CZ)](StructureDefinition-cz-conditionLab.md)

### Logical Definition (CLD)

This value set includes codes based on the following rules:

* Include all codes defined in `https://terminology.uzis.cz/CodeSystem/Mkn10_5` version Not Stated (use latest from terminology server)
* Include all codes defined in `https://www.orphadata.com/` version Not Stated (use latest from terminology server)

 

### Expansion

No Expansion for this valueset (Unknown Code System)

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.lab-order#0.0.1 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-08 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

