# Specimen: Laboratory Order (CZ) - HL7 Czech Laboratory Order IG v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Specimen: Laboratory Order (CZ)**

HL7 Czech Laboratory Order IG, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.1 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/lab-order/](https://github.com/HL7-cz/lab-order/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/lab-order/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-cz-specimen-definitions.md) 
*  [Mappings](StructureDefinition-cz-specimen-mappings.md) 
*  [Examples](StructureDefinition-cz-specimen-examples.md) 
*  [XML](StructureDefinition-cz-specimen.profile.xml.md) 
*  [JSON](StructureDefinition-cz-specimen.profile.json.md) 
*  [TTL](StructureDefinition-cz-specimen.profile.ttl.md) 

## Resource Profile: Specimen: Laboratory Order (CZ) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab-order/StructureDefinition/cz-specimen | *Version*:0.0.1 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:CZ_SpecimenLab |

 
Czech profile for a specimen in a laboratory order. In some laboratory order, specimen information is allowed to be minimal as many informations concerning the specimen are implied by the observations done. 

**Usages:**

* Refer to this Profile: [Attachment Laboratory Order (CZ)](StructureDefinition-cz-attachment.md)
* Examples for this Profile: [Specimen/CZ-Lab-Specimen-Example](Specimen-CZ-Lab-Specimen-Example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab-order|current/StructureDefinition/cz-specimen)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [CZ_Specimen](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-specimen.html) 

#### Terminology Bindings

#### Constraints

This structure is derived from [CZ_Specimen](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-specimen.html) 

**Summary**

Must-Support: 4 elements

**Structures**

This structure refers to these other structures:

* [ServiceRequest: Laboratory Order (CZ)(https://hl7.cz/fhir/lab-order/StructureDefinition/cz-serviceRequest)](StructureDefinition-cz-serviceRequest.md)

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 0

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [CZ_Specimen](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-specimen.html) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [CZ_Specimen](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-specimen.html) 

**Summary**

Must-Support: 4 elements

**Structures**

This structure refers to these other structures:

* [ServiceRequest: Laboratory Order (CZ)(https://hl7.cz/fhir/lab-order/StructureDefinition/cz-serviceRequest)](StructureDefinition-cz-serviceRequest.md)

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 0

 

Other representations of profile: [CSV](StructureDefinition-cz-specimen.csv), [Excel](StructureDefinition-cz-specimen.xlsx), [Schematron](StructureDefinition-cz-specimen.sch) 

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.lab-order#0.0.1 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-08 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

