# ServiceRequest: Laboratory Order (CZ) - HL7 Czech Laboratory Order IG v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ServiceRequest: Laboratory Order (CZ)**

HL7 Czech Laboratory Order IG, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.1 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/lab-order/](https://github.com/HL7-cz/lab-order/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/lab-order/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-cz-serviceRequest-definitions.md) 
*  [Mappings](StructureDefinition-cz-serviceRequest-mappings.md) 
*  [Examples](StructureDefinition-cz-serviceRequest-examples.md) 
*  [XML](StructureDefinition-cz-serviceRequest.profile.xml.md) 
*  [JSON](StructureDefinition-cz-serviceRequest.profile.json.md) 
*  [TTL](StructureDefinition-cz-serviceRequest.profile.ttl.md) 

## Resource Profile: ServiceRequest: Laboratory Order (CZ) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab-order/StructureDefinition/cz-serviceRequest | *Version*:0.0.1 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:CZ_ServiceRequest |

 
ServiceRequest used to represent a Laboratory Order for the scope of the Czech national interoperability project. 

**Usages:**

* Use this Profile: [Bundle: Laboratory Order (CZ)](StructureDefinition-BundleLabOrderCz.md)
* Refer to this Profile: [Composition: Laboratory Order (CZ)](StructureDefinition-cz-CompositionLabOrder.md), [Attachment Laboratory Order (CZ)](StructureDefinition-cz-attachment.md) and [Specimen: Laboratory Order (CZ)](StructureDefinition-cz-specimen.md)
* Examples for this Profile: [ServiceRequest/CZ-Lab-ServiceRequest-Example](ServiceRequest-CZ-Lab-ServiceRequest-Example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab-order|current/StructureDefinition/cz-serviceRequest)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [ServiceRequest](http://hl7.org/fhir/R4/servicerequest.html) 

#### Terminology Bindings (Differential)

#### Terminology Bindings

#### Constraints

This structure is derived from [ServiceRequest](http://hl7.org/fhir/R4/servicerequest.html) 

**Summary**

Mandatory: 5 elements(2 nested mandatory elements)
 Fixed: 1 element

**Structures**

This structure refers to these other structures:

* [Patient: Animal (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-patient-animal)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-animal.html)
* [Patient (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)
* [Location (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-location-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-location-core.html)
* [Practitioner (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitioner-core.html)
* [Practitioner Role (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitionerrole-core.html)
* [Organization (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-organization-core.html)
* [Related Person (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-relatedPerson-core.html)
* [Coverage (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-coverage)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-coverage.html)
* [Medication Statement (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-MedicationStatement)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-MedicationStatement.html)
* [Allergy Intolerance (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-allergyIntolerance)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-allergyIntolerance.html)
* [Medical Device (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-medical-device)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-medical-device.html)
* [Observation: Laboratory Order (CZ)(https://hl7.cz/fhir/lab-order/StructureDefinition/cz-observation)](StructureDefinition-cz-observation.md)
* [Specimen (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-specimen)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-specimen.html)

**Extensions**

This structure refers to these extensions:

* [https://hl7.cz/fhir/lab-order/StructureDefinition/accreditation-cz](StructureDefinition-accreditation-cz.md)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of ServiceRequest.reasonCode.coding

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 0

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [ServiceRequest](http://hl7.org/fhir/R4/servicerequest.html) 

#### Terminology Bindings (Differential)

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [ServiceRequest](http://hl7.org/fhir/R4/servicerequest.html) 

**Summary**

Mandatory: 5 elements(2 nested mandatory elements)
 Fixed: 1 element

**Structures**

This structure refers to these other structures:

* [Patient: Animal (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-patient-animal)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-animal.html)
* [Patient (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)
* [Location (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-location-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-location-core.html)
* [Practitioner (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitioner-core.html)
* [Practitioner Role (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitionerrole-core.html)
* [Organization (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-organization-core.html)
* [Related Person (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-relatedPerson-core.html)
* [Coverage (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-coverage)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-coverage.html)
* [Medication Statement (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-MedicationStatement)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-MedicationStatement.html)
* [Allergy Intolerance (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-allergyIntolerance)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-allergyIntolerance.html)
* [Medical Device (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-medical-device)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-medical-device.html)
* [Observation: Laboratory Order (CZ)(https://hl7.cz/fhir/lab-order/StructureDefinition/cz-observation)](StructureDefinition-cz-observation.md)
* [Specimen (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-specimen)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-specimen.html)

**Extensions**

This structure refers to these extensions:

* [https://hl7.cz/fhir/lab-order/StructureDefinition/accreditation-cz](StructureDefinition-accreditation-cz.md)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of ServiceRequest.reasonCode.coding

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 0

 

Other representations of profile: [CSV](StructureDefinition-cz-serviceRequest.csv), [Excel](StructureDefinition-cz-serviceRequest.xlsx), [Schematron](StructureDefinition-cz-serviceRequest.sch) 

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.lab-order#0.0.1 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-08 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

