# Observation: Laboratory Order (CZ) - HL7 Czech Laboratory Order IG v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Observation: Laboratory Order (CZ)**

HL7 Czech Laboratory Order IG, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.1 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/lab-order/](https://github.com/HL7-cz/lab-order/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/lab-order/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-cz-observation-definitions.md) 
*  [Mappings](StructureDefinition-cz-observation-mappings.md) 
*  [XML](StructureDefinition-cz-observation.profile.xml.md) 
*  [JSON](StructureDefinition-cz-observation.profile.json.md) 
*  [TTL](StructureDefinition-cz-observation.profile.ttl.md) 

## Resource Profile: Observation: Laboratory Order (CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab-order/StructureDefinition/cz-observation | *Version*:0.0.1 |
| Draft as of 2025-10-08 | *Computable Name*:CZ_ObservationLab |

 
Observation for Laboratory Order for the scope of the Czech national interoperability project. 

**Usages:**

* Use this Profile: [Bundle: Laboratory Order (CZ)](StructureDefinition-BundleLabOrderCz.md)
* Refer to this Profile: [ServiceRequest: Laboratory Order (CZ)](StructureDefinition-cz-serviceRequest.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab-order|current/StructureDefinition/cz-observation)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Observation](http://hl7.org/fhir/R4/observation.html) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Observation](http://hl7.org/fhir/R4/observation.html) 

**Summary**

Mandatory: 0 element(6 nested mandatory elements)
 Fixed: 3 elements

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Observation.code.coding

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [Observation](http://hl7.org/fhir/R4/observation.html) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Observation](http://hl7.org/fhir/R4/observation.html) 

**Summary**

Mandatory: 0 element(6 nested mandatory elements)
 Fixed: 3 elements

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Observation.code.coding

 

Other representations of profile: [CSV](StructureDefinition-cz-observation.csv), [Excel](StructureDefinition-cz-observation.xlsx), [Schematron](StructureDefinition-cz-observation.sch) 

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.lab-order#0.0.1 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-08 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

