# Attachment Laboratory Order (CZ) - HL7 Czech Laboratory Order IG v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Attachment Laboratory Order (CZ)**

HL7 Czech Laboratory Order IG, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.1 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/lab-order/](https://github.com/HL7-cz/lab-order/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/lab-order/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-cz-attachment-definitions.md) 
*  [Mappings](StructureDefinition-cz-attachment-mappings.md) 
*  [XML](StructureDefinition-cz-attachment.profile.xml.md) 
*  [JSON](StructureDefinition-cz-attachment.profile.json.md) 
*  [TTL](StructureDefinition-cz-attachment.profile.ttl.md) 

## Resource Profile: Attachment Laboratory Order (CZ) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab-order/StructureDefinition/cz-attachment | *Version*:0.0.1 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:CZ_Attachment |

 
Czech profile for attachment. 

**Usages:**

* Use this Profile: [Bundle: Laboratory Order (CZ)](StructureDefinition-BundleLabOrderCz.md)
* Refer to this Profile: [Composition: Laboratory Order (CZ)](StructureDefinition-cz-CompositionLabOrder.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab-order|current/StructureDefinition/cz-attachment)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Media](http://hl7.org/fhir/R4/media.html) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Media](http://hl7.org/fhir/R4/media.html) 

**Summary**

Must-Support: 5 elements

**Structures**

This structure refers to these other structures:

* [ServiceRequest: Laboratory Order (CZ)(https://hl7.cz/fhir/lab-order/StructureDefinition/cz-serviceRequest)](StructureDefinition-cz-serviceRequest.md)
* [Patient (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)
* [Practitioner (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitioner-core.html)
* [Practitioner Role (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitionerrole-core.html)
* [Specimen: Laboratory Order (CZ)(https://hl7.cz/fhir/lab-order/StructureDefinition/cz-specimen)](StructureDefinition-cz-specimen.md)
* [Location (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-location-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-location-core.html)
* [Organization (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-organization-core.html)
* [Related Person (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-relatedPerson-core.html)

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 0

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [Media](http://hl7.org/fhir/R4/media.html) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Media](http://hl7.org/fhir/R4/media.html) 

**Summary**

Must-Support: 5 elements

**Structures**

This structure refers to these other structures:

* [ServiceRequest: Laboratory Order (CZ)(https://hl7.cz/fhir/lab-order/StructureDefinition/cz-serviceRequest)](StructureDefinition-cz-serviceRequest.md)
* [Patient (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)
* [Practitioner (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitioner-core.html)
* [Practitioner Role (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitionerrole-core.html)
* [Specimen: Laboratory Order (CZ)(https://hl7.cz/fhir/lab-order/StructureDefinition/cz-specimen)](StructureDefinition-cz-specimen.md)
* [Location (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-location-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-location-core.html)
* [Organization (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-organization-core.html)
* [Related Person (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-relatedPerson-core.html)

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 0

 

Other representations of profile: [CSV](StructureDefinition-cz-attachment.csv), [Excel](StructureDefinition-cz-attachment.xlsx), [Schematron](StructureDefinition-cz-attachment.sch) 

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.lab-order#0.0.1 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-08 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

