# Appointment (CZ) - HL7 Czech Laboratory Order IG v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Appointment (CZ)**

HL7 Czech Laboratory Order IG, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.1 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/lab-order/](https://github.com/HL7-cz/lab-order/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/lab-order/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-cz-appointment-definitions.md) 
*  [Mappings](StructureDefinition-cz-appointment-mappings.md) 
*  [Examples](StructureDefinition-cz-appointment-examples.md) 
*  [XML](StructureDefinition-cz-appointment.profile.xml.md) 
*  [JSON](StructureDefinition-cz-appointment.profile.json.md) 
*  [TTL](StructureDefinition-cz-appointment.profile.ttl.md) 

## Resource Profile: Appointment (CZ) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab-order/StructureDefinition/cz-appointment | *Version*:0.0.1 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:CZ_Appointment |

 
Czech profile for appointment. 

**Usages:**

* Use this Profile: [Bundle: Laboratory Order (CZ)](StructureDefinition-BundleLabOrderCz.md)
* Refer to this Profile: [Composition: Laboratory Order (CZ)](StructureDefinition-cz-CompositionLabOrder.md)
* Examples for this Profile: [Appointment/AppointmentExample](Appointment-AppointmentExample.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab-order|current/StructureDefinition/cz-appointment)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Appointment](http://hl7.org/fhir/R4/appointment.html) 

#### Terminology Bindings (Differential)

#### Terminology Bindings

#### Constraints

This structure is derived from [Appointment](http://hl7.org/fhir/R4/appointment.html) 

**Summary**

Mandatory: 1 element

**Structures**

This structure refers to these other structures:

* [Location (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-location-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-location-core.html)

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 0

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [Appointment](http://hl7.org/fhir/R4/appointment.html) 

#### Terminology Bindings (Differential)

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Appointment](http://hl7.org/fhir/R4/appointment.html) 

**Summary**

Mandatory: 1 element

**Structures**

This structure refers to these other structures:

* [Location (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-location-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-location-core.html)

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 0

 

Other representations of profile: [CSV](StructureDefinition-cz-appointment.csv), [Excel](StructureDefinition-cz-appointment.xlsx), [Schematron](StructureDefinition-cz-appointment.sch) 

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.lab-order#0.0.1 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-08 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

